/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;

public class AnnotationHierarchyUtil {
    private final Types types;

    public AnnotationHierarchyUtil(Types types) {
        this.types = types;
    }

    public Set<TypeElement> filterTriggeringAnnotations(Set<? extends TypeElement> aAnnotations, TypeElement generatePojoBuilderAnnotation) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeElement typeElement : aAnnotations) {
            Set<TypeElement> hierarchy = this.getAnnotationHierarchy(typeElement);
            if (!this.containsAnnotation(hierarchy, generatePojoBuilderAnnotation)) continue;
            result.add(typeElement);
        }
        return result;
    }

    private Set<TypeElement> getAnnotationHierarchy(TypeElement annoTypeEl) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        this.getAnnotationHierarchy(annoTypeEl, result);
        return result;
    }

    private void getAnnotationHierarchy(TypeElement annoTypeEl, Set<TypeElement> result) {
        if (result.add(annoTypeEl)) {
            List<? extends AnnotationMirror> annos = annoTypeEl.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annos) {
                DeclaredType annoDeclType = annotationMirror.getAnnotationType();
                Element annoEl = annoDeclType.asElement();
                if (annoEl.getKind() != ElementKind.ANNOTATION_TYPE) continue;
                this.getAnnotationHierarchy((TypeElement)annoEl, result);
            }
        }
    }

    private boolean containsAnnotation(Set<TypeElement> elems, TypeElement annoEl) {
        for (TypeElement el : elems) {
            if (!this.types.isSameType(annoEl.asType(), el.asType())) continue;
            return true;
        }
        return false;
    }
}

