/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.googlecode.totallylazy.Sequence;
import com.googlecode.totallylazy.Sequences;
import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.ScenarioTag;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.util.Status;
import net.masterthought.cucumber.util.Util;

public class TagObject {
    private String tagName;
    private List<ScenarioTag> scenarios = new ArrayList<ScenarioTag>();
    private List<Element> elements = new ArrayList<Element>();

    public String getTagName() {
        return this.tagName;
    }

    public String getFileName() {
        return this.tagName.replace("@", "").trim() + ".html";
    }

    public List<ScenarioTag> getScenarios() {
        return this.scenarios;
    }

    public void setScenarios(List<ScenarioTag> scenarioTagList) {
        this.scenarios = scenarioTagList;
    }

    public TagObject(String tagName, List<ScenarioTag> scenarios) {
        this.tagName = tagName;
        this.scenarios = scenarios;
    }

    private void populateElements() {
        for (ScenarioTag scenarioTag : this.scenarios) {
            this.elements.add(scenarioTag.getScenario());
        }
    }

    public Integer getNumberOfScenarios() {
        ArrayList<ScenarioTag> scenarioTagList = new ArrayList<ScenarioTag>();
        for (ScenarioTag scenarioTag : this.scenarios) {
            if (scenarioTag.getScenario().isBackground()) continue;
            scenarioTagList.add(scenarioTag);
        }
        return scenarioTagList.size();
    }

    public Integer getNumberOfPassingScenarios() {
        return this.getNumberOfScenariosForStatus(Status.PASSED);
    }

    public Integer getNumberOfFailingScenarios() {
        return this.getNumberOfScenariosForStatus(Status.FAILED);
    }

    private Integer getNumberOfScenariosForStatus(Status status) {
        ArrayList<ScenarioTag> scenarioTagList = new ArrayList<ScenarioTag>();
        for (ScenarioTag scenarioTag : this.scenarios) {
            if (scenarioTag.getScenario().isBackground() || !scenarioTag.getScenario().getStatus().equals((Object)status)) continue;
            scenarioTagList.add(scenarioTag);
        }
        return scenarioTagList.size();
    }

    public String getDurationOfSteps() {
        Long duration = 0L;
        for (ScenarioTag scenarioTag : this.scenarios) {
            if (!scenarioTag.hasSteps()) continue;
            for (Step step : scenarioTag.getScenario().getSteps()) {
                duration = duration + step.getDuration();
            }
        }
        return Util.formatDuration(duration);
    }

    public int getNumberOfSteps() {
        int totalSteps = 0;
        for (ScenarioTag scenario : this.scenarios) {
            if (!scenario.hasSteps()) continue;
            totalSteps += scenario.getScenario().getSteps().size();
        }
        return totalSteps;
    }

    public int getNumberOfStatus(Status status) {
        return Util.findStatusCount(this.getStatuses(), status);
    }

    public int getNumberOfPasses() {
        return this.getNumberOfStatus(Status.PASSED);
    }

    public int getNumberOfFailures() {
        return this.getNumberOfStatus(Status.FAILED);
    }

    public int getNumberOfSkipped() {
        return this.getNumberOfStatus(Status.SKIPPED);
    }

    public int getNumberOfUndefined() {
        return this.getNumberOfStatus(Status.UNDEFINED);
    }

    public int getNumberOfMissing() {
        return this.getNumberOfStatus(Status.MISSING);
    }

    public int getNumberOfPending() {
        return this.getNumberOfStatus(Status.UNDEFINED);
    }

    private List<Status> getStatuses() {
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (ScenarioTag scenarioTag : this.scenarios) {
            if (!scenarioTag.hasSteps()) continue;
            for (Step step : scenarioTag.getScenario().getSteps()) {
                statuses.add(step.getStatus());
            }
        }
        return statuses;
    }

    public Sequence<Element> getElements() {
        this.populateElements();
        return Sequences.sequence(this.elements);
    }

    public Status getStatus() {
        Sequence results = this.getElements().map(Element.Functions.status());
        return results.contains((Object)Status.FAILED) ? Status.FAILED : Status.PASSED;
    }

    public String getRawStatus() {
        return this.getStatus().toString().toLowerCase();
    }
}

