/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.ValidationException;
import org.apache.commons.io.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public abstract class AbstractPage {
    private static final Logger LOG = LogManager.getLogger(AbstractPage.class);
    protected final VelocityEngine ve = new VelocityEngine();
    protected final VelocityContext velocityContext = new VelocityContext();
    private Template template;
    private final String templateFileName;
    protected final ReportResult report;
    protected final Configuration configuration;

    protected AbstractPage(ReportResult reportResult, String templateFileName, Configuration configuration) {
        this.templateFileName = templateFileName;
        this.report = reportResult;
        this.configuration = configuration;
        this.buildGeneralParameters();
    }

    public final void generatePage() {
        this.ve.init(this.getProperties());
        this.template = this.ve.getTemplate("templates/pages/" + this.templateFileName);
        this.prepareReport();
        this.generateReport();
    }

    public abstract String getWebPage();

    protected abstract void prepareReport();

    private void generateReport() {
        this.velocityContext.put("page_url", (Object)this.getWebPage());
        File dir = new File(this.configuration.getReportDirectory(), this.getWebPage());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dir), Charsets.UTF_8);){
            this.template.merge((Context)this.velocityContext, (Writer)writer);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    private Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("resource.loader", "class");
        props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.setProperty("runtime.log", new File(this.configuration.getReportDirectory(), "velocity.log").getPath());
        return props;
    }

    private void buildGeneralParameters() {
        String buildNumber;
        this.velocityContext.put("jenkins_source", (Object)this.configuration.isRunWithJenkins());
        this.velocityContext.put("jenkins_base", (Object)this.configuration.getJenkinsBasePath());
        this.velocityContext.put("build_project_name", (Object)this.configuration.getProjectName());
        this.velocityContext.put("build_number", (Object)this.configuration.getBuildNumber());
        if (this.report != null) {
            this.velocityContext.put("build_time", (Object)this.report.getBuildTime());
        }
        if ((buildNumber = this.configuration.getBuildNumber()) != null) {
            try {
                int buildValue = Integer.parseInt(buildNumber);
                this.velocityContext.put("build_previous_number", (Object)(--buildValue));
            }
            catch (NumberFormatException e) {
                LOG.error("Could not parse build number: {}.", new Object[]{this.configuration.getBuildNumber(), e});
            }
        }
    }
}

