/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class Feature {
    private final String id;
    private final String name;
    private final String uri;
    private final String description;
    private final String keyword;
    private final Element[] elements = new Element[0];
    private final Tag[] tags = new Tag[0];
    private String jsonFile;
    private String reportFileName;
    private String deviceName;
    private final List<Element> scenarios = new ArrayList<Element>();
    private final StatusCounter scenarioCounter = new StatusCounter();
    private Status featureStatus;
    private final StatusCounter statusCounter = new StatusCounter();
    private long totalDuration;
    private int totalSteps;

    public Feature() {
        this.id = null;
        this.name = null;
        this.uri = null;
        this.description = null;
        this.keyword = null;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getId() {
        return this.id;
    }

    public Element[] getElements() {
        return this.elements;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public boolean hasTags() {
        return ArrayUtils.isNotEmpty((Object[])this.tags);
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public String getTagsList() {
        return Util.tagsToHtml(this.tags);
    }

    public Status getStatus() {
        return this.featureStatus;
    }

    public String getName() {
        return StringUtils.defaultString((String)this.name);
    }

    public String getKeyword() {
        return StringUtils.defaultString((String)this.keyword);
    }

    public String getRawName() {
        return StringUtils.isNotEmpty((String)this.name) ? StringEscapeUtils.escapeHtml((String)this.name) : "";
    }

    public String getRawStatus() {
        return this.getStatus().toString().toLowerCase();
    }

    public String getDescription() {
        return StringUtils.defaultString((String)this.description);
    }

    public int getScenarios() {
        return this.scenarios.size();
    }

    public int getNumberOfSteps() {
        return this.totalSteps;
    }

    public int getNumberOfPasses() {
        return this.statusCounter.getValueFor(Status.PASSED);
    }

    public int getNumberOfFailures() {
        return this.statusCounter.getValueFor(Status.FAILED);
    }

    public int getNumberOfPending() {
        return this.statusCounter.getValueFor(Status.PENDING);
    }

    public int getNumberOfSkipped() {
        return this.statusCounter.getValueFor(Status.SKIPPED);
    }

    public int getNumberOfMissing() {
        return this.statusCounter.getValueFor(Status.MISSING);
    }

    public int getNumberOfUndefined() {
        return this.statusCounter.getValueFor(Status.UNDEFINED);
    }

    public String getTotalDuration() {
        return Util.formatDuration(this.totalDuration);
    }

    public int getPassedScenarios() {
        return this.scenarioCounter.getValueFor(Status.PASSED);
    }

    public int getFailedScenarios() {
        return this.scenarioCounter.getValueFor(Status.FAILED);
    }

    public void setMetaData(String jsonFile, int jsonFileNo, Configuration configuration) {
        this.jsonFile = StringUtils.substringAfterLast((String)jsonFile, (String)"/");
        for (Element element : this.elements) {
            element.setMedaData(this, configuration);
            if (!element.isScenario()) continue;
            this.scenarios.add(element);
        }
        this.setDeviceName();
        this.setReportFileName(jsonFileNo, configuration);
        this.calculateFeatureStatus();
        this.calculateSteps();
    }

    private void setDeviceName() {
        String[] splitedJsonFile = this.jsonFile.split("[^\\d\\w]");
        this.deviceName = splitedJsonFile.length > 1 ? splitedJsonFile[splitedJsonFile.length - 2] : splitedJsonFile[0];
    }

    private void setReportFileName(int jsonFileNo, Configuration configuration) {
        this.reportFileName = this.uri.replaceAll("[^\\d\\w]", "-");
        if (configuration.isParallelTesting()) {
            this.reportFileName = this.reportFileName + "_" + this.getDeviceName();
        }
        if (jsonFileNo > 0) {
            this.reportFileName = this.reportFileName + "_" + jsonFileNo;
        }
        this.reportFileName = this.reportFileName + ".html";
    }

    private void calculateFeatureStatus() {
        for (Element element : this.elements) {
            if (element.getStatus() == Status.PASSED) continue;
            this.featureStatus = Status.FAILED;
            return;
        }
        this.featureStatus = Status.PASSED;
    }

    private void calculateSteps() {
        for (Element element : this.elements) {
            if (element.isScenario()) {
                this.scenarioCounter.incrementFor(element.getStatus());
            }
            this.totalSteps += element.getSteps().length;
            for (Step step : element.getSteps()) {
                this.statusCounter.incrementFor(step.getStatus());
                this.totalDuration += step.getDuration();
            }
        }
    }
}

