/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.support;

import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.reports.Reportable;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.NotImplementedException;

public class TagObject
implements Reportable,
Comparable<TagObject> {
    private final String name;
    private final List<Element> elements = new ArrayList<Element>();
    private final String reportFileName;
    private int scenarioCounter;
    private StatusCounter elementsStatusCounter = new StatusCounter();
    private StatusCounter stepsStatusCounter = new StatusCounter();
    private long totalDuration;
    private int totalSteps;
    private Status status = Status.PASSED;

    public TagObject(String tagName) {
        this.name = tagName;
        this.reportFileName = tagName.replace("@", "").replaceAll(":", "-").trim() + ".html";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public boolean addElement(Element element) {
        if (this.elements.contains(element)) {
            return false;
        }
        this.elements.add(element);
        if (this.status != Status.FAILED && element.getElementStatus() != Status.PASSED) {
            this.status = Status.FAILED;
        }
        if (element.isScenario()) {
            ++this.scenarioCounter;
        }
        this.elementsStatusCounter.incrementFor(element.getElementStatus());
        for (Step step : element.getSteps()) {
            this.stepsStatusCounter.incrementFor(step.getStatus());
            this.totalDuration += step.getDuration();
            ++this.totalSteps;
        }
        return true;
    }

    @Override
    public int getScenarios() {
        return this.scenarioCounter;
    }

    @Override
    public int getPassedScenarios() {
        return this.elementsStatusCounter.getValueFor(Status.PASSED);
    }

    @Override
    public int getFailedScenarios() {
        return this.elementsStatusCounter.getValueFor(Status.FAILED);
    }

    @Override
    public long getDurations() {
        return this.totalDuration;
    }

    @Override
    public String getFormattedDurations() {
        return Util.formatDuration(this.getDurations());
    }

    @Override
    public int getSteps() {
        return this.totalSteps;
    }

    public int getNumberOfStatus(Status status) {
        return this.stepsStatusCounter.getValueFor(status);
    }

    @Override
    public int getPassedSteps() {
        return this.getNumberOfStatus(Status.PASSED);
    }

    @Override
    public int getFailedSteps() {
        return this.getNumberOfStatus(Status.FAILED);
    }

    @Override
    public int getSkippedSteps() {
        return this.getNumberOfStatus(Status.SKIPPED);
    }

    @Override
    public int getUndefinedSteps() {
        return this.getNumberOfStatus(Status.UNDEFINED);
    }

    @Override
    public int getMissingSteps() {
        return this.getNumberOfStatus(Status.MISSING);
    }

    @Override
    public int getPendingSteps() {
        return this.getNumberOfStatus(Status.PENDING);
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public String getRawStatus() {
        return this.status.name().toLowerCase();
    }

    @Override
    public String getDeviceName() {
        throw new NotImplementedException();
    }

    @Override
    public int compareTo(TagObject o) {
        return Integer.signum(this.name.compareTo(o.getName()));
    }
}

