/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public final class Util {
    public static final NumberFormat PERCENT_FORMATTER = NumberFormat.getPercentInstance(Locale.US);
    private static final NumberFormat DECIMAL_FORMATTER;
    public static final Util INSTANCE;
    private static final PeriodFormatter TIME_FORMATTER;

    private Util() {
    }

    public static String formatDuration(long duration) {
        return TIME_FORMATTER.print((ReadablePeriod)new Period(0L, duration / 1000000L));
    }

    public static String formatAsPercentage(int value, int total) {
        float average = total == 0 ? 0.0f : 1.0f * (float)value / (float)total;
        return PERCENT_FORMATTER.format(average);
    }

    public static String formatAsDecimal(int value, int total) {
        float average = total == 0 ? 0.0f : 100.0f * (float)value / (float)total;
        return DECIMAL_FORMATTER.format(average);
    }

    public static String toValidFileName(String fileName) {
        return StringEscapeUtils.escapeJava((String)fileName).replaceAll("[^\\d\\w]", "-");
    }

    static {
        PERCENT_FORMATTER.setMinimumFractionDigits(2);
        PERCENT_FORMATTER.setMaximumFractionDigits(2);
        DECIMAL_FORMATTER = DecimalFormat.getInstance(Locale.US);
        DECIMAL_FORMATTER.setMinimumFractionDigits(2);
        DECIMAL_FORMATTER.setMaximumFractionDigits(2);
        INSTANCE = new Util();
        TIME_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendSeparator(" ").appendHours().appendSuffix("h").appendSeparator(" ").appendMinutes().appendSuffix("m").appendSeparator(" ").appendSeconds().appendSuffix("s").appendSeparator(" ").minimumPrintedDigits(3).appendMillis().appendSuffix("ms").toFormatter();
    }
}

