/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.deserializers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.json.deserializers.CucumberJsonDeserializer;
import net.masterthought.cucumber.json.support.Status;

public class StatusDeserializer
extends CucumberJsonDeserializer<Status> {
    static final List<String> UNKNOWN_STATUSES = Arrays.asList("ambiguous");

    @Override
    public Status deserialize(JsonNode rootNode, Configuration configuration) {
        String status = rootNode.asText();
        if (UNKNOWN_STATUSES.contains(status)) {
            return Status.UNDEFINED;
        }
        return Status.valueOf(status.toUpperCase());
    }
}

