/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import net.masterthought.cucumber.json.DocString;
import net.masterthought.cucumber.json.Embedding;
import net.masterthought.cucumber.json.Hook;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Output;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Row;
import net.masterthought.cucumber.json.deserializers.OutputsDeserializer;
import net.masterthought.cucumber.json.support.Argument;
import net.masterthought.cucumber.json.support.Resultsable;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import org.apache.commons.lang3.ArrayUtils;

public class Step
implements Resultsable {
    private String name = null;
    private final String keyword;
    private Integer line = null;
    private final Result result = new Result();
    private final Row[] rows = new Row[0];
    @JsonProperty(value="arguments")
    private final Argument[] arguments = new Argument[0];
    private final Match match = null;
    private final Embedding[] embeddings = new Embedding[0];
    @JsonDeserialize(using=OutputsDeserializer.class)
    @JsonProperty(value="output")
    private final Output[] outputs = new Output[0];
    @JsonProperty(value="doc_string")
    private final DocString docString = null;
    private final Hook[] before = new Hook[0];
    private final Hook[] after = new Hook[0];
    private Status beforeStatus;
    private Status afterStatus;

    public Step() {
        this.keyword = null;
    }

    public Row[] getRows() {
        if (ArrayUtils.getLength((Object)this.arguments) == 1) {
            return this.arguments[0].getRows();
        }
        if (ArrayUtils.getLength((Object)this.arguments) > 1) {
            throw new UnsupportedOperationException("'arguments' length should be equal to 1");
        }
        return this.rows;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword.trim();
    }

    public Integer getLine() {
        return this.line;
    }

    @Override
    public Output[] getOutputs() {
        return this.outputs;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    public Embedding[] getEmbeddings() {
        return this.embeddings;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    public long getDuration() {
        return this.result.getDuration();
    }

    public DocString getDocString() {
        return this.docString;
    }

    public Hook[] getBefore() {
        return this.before;
    }

    public Hook[] getAfter() {
        return this.after;
    }

    public Status getBeforeStatus() {
        return this.beforeStatus;
    }

    public Status getAfterStatus() {
        return this.afterStatus;
    }

    public void setMetaData() {
        this.beforeStatus = new StatusCounter(this.before).getFinalStatus();
        this.afterStatus = new StatusCounter(this.after).getFinalStatus();
    }
}

