/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.biz.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.util.PinYinUtil;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.dao.ICategoryDao;
import net.mingsoft.cms.dao.IContentDao;
import net.mingsoft.cms.entity.CategoryEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cmscategoryBizImpl")
@Transactional(rollbackFor={RuntimeException.class})
public class CategoryBizImpl
extends BaseBizImpl<ICategoryDao, CategoryEntity>
implements ICategoryBiz {
    @Autowired
    private ICategoryDao categoryDao;
    @Autowired
    private IContentDao contentDao;

    protected IBaseDao getDao() {
        return this.categoryDao;
    }

    @Override
    public List<CategoryEntity> queryChilds(CategoryEntity category) {
        return this.categoryDao.queryChildren(category);
    }

    @Override
    public void saveEntity(CategoryEntity categoryEntity) {
        CategoryEntity parent;
        String pingYin = PinYinUtil.getPingYin((String)categoryEntity.getCategoryTitle());
        if (StrUtil.isNotBlank((CharSequence)categoryEntity.getCategoryPinyin())) {
            pingYin = categoryEntity.getCategoryPinyin();
        }
        CategoryEntity category = new CategoryEntity();
        category.setCategoryPinyin(pingYin);
        Object categoryBizEntity = this.getEntity(category);
        this.setParentId(categoryEntity);
        categoryEntity.setCategoryPinyin(pingYin);
        if (StrUtil.isNotBlank((CharSequence)categoryEntity.getCategoryId()) && !"0".equals(categoryEntity.getCategoryId()) && (parent = (CategoryEntity)((Object)this.getById((Serializable)((Object)categoryEntity.getCategoryId())))).getLeaf().booleanValue()) {
            parent.setLeaf(false);
            this.updateById((Object)parent);
        }
        categoryEntity.setLeaf(false);
        if (StrUtil.isEmpty((CharSequence)categoryEntity.getId())) {
            categoryEntity.setLeaf(true);
        }
        super.save((Object)categoryEntity);
        if (categoryBizEntity != null) {
            categoryEntity.setCategoryPinyin(pingYin + categoryEntity.getId());
        }
        CategoryEntity parentCategory = null;
        if (StringUtils.isNotBlank((CharSequence)categoryEntity.getCategoryId())) {
            parentCategory = (CategoryEntity)((Object)this.getById((Serializable)((Object)categoryEntity.getCategoryId())));
        }
        String path = ObjectUtil.isNotNull(parentCategory) ? parentCategory.getCategoryPath() : "";
        categoryEntity.setCategoryPath(path + "/" + categoryEntity.getCategoryPinyin());
        this.setTopId(categoryEntity);
        super.updateById((Object)categoryEntity);
    }

    private void setParentId(CategoryEntity categoryEntity) {
        String path = "";
        if (StringUtils.isNotEmpty((CharSequence)categoryEntity.getCategoryId()) && Long.parseLong(categoryEntity.getCategoryId()) > 0L) {
            CategoryEntity category = (CategoryEntity)((Object)this.getById((Serializable)((Object)categoryEntity.getCategoryId())));
            path = category.getCategoryPath();
            if (StringUtils.isEmpty((CharSequence)category.getCategoryParentIds())) {
                categoryEntity.setCategoryParentIds(category.getId());
            } else {
                categoryEntity.setCategoryParentIds(category.getCategoryParentIds() + "," + category.getId());
            }
        } else {
            categoryEntity.setCategoryParentIds(null);
        }
        if (StringUtils.isNotBlank((CharSequence)categoryEntity.getId())) {
            categoryEntity.setCategoryPath(path + "/" + categoryEntity.getCategoryPinyin());
        }
    }

    private void setChildParentId(CategoryEntity categoryEntity, String topId) {
        CategoryEntity category = new CategoryEntity();
        category.setCategoryId(categoryEntity.getId());
        List list = this.categoryDao.query(category);
        list.forEach(x -> {
            if (StringUtils.isEmpty((CharSequence)categoryEntity.getCategoryParentIds())) {
                x.setCategoryParentIds(categoryEntity.getId());
            } else {
                x.setCategoryParentIds(categoryEntity.getCategoryParentIds() + "," + categoryEntity.getId());
            }
            x.setTopId(topId);
            String path = categoryEntity.getCategoryPath();
            x.setCategoryPath(path + "/" + x.getCategoryPinyin());
            super.updateEntity((BaseEntity)x);
            this.setChildParentId((CategoryEntity)((Object)x), topId);
        });
    }

    @Override
    public void updateEntity(CategoryEntity entity) {
        this.setParentId(entity);
        String pingYin = entity.getCategoryPinyin();
        if (StrUtil.isNotBlank((CharSequence)pingYin)) {
            CategoryEntity category = new CategoryEntity();
            category.setCategoryPinyin(pingYin);
            CategoryEntity categoryBizEntity = (CategoryEntity)((Object)this.getEntity(category));
            if (categoryBizEntity != null && !categoryBizEntity.getId().equals(entity.getId())) {
                entity.setCategoryPinyin(pingYin + entity.getId());
            }
        }
        this.setParentLeaf(entity);
        this.setTopId(entity);
        if (StringUtils.isEmpty((CharSequence)entity.getCategoryId())) {
            entity.setCategoryId(null);
        }
        if (StringUtils.isEmpty((CharSequence)entity.getCategoryParentIds())) {
            entity.setCategoryParentIds(null);
        }
        this.categoryDao.updateEntity(entity);
        String topId = entity.getTopId();
        if (topId.equals("0")) {
            topId = entity.getId();
        }
        this.setChildParentId(entity, topId);
    }

    @Override
    public void update(CategoryEntity entity) {
        super.updateEntity((BaseEntity)entity);
    }

    @Override
    public void delete(String categoryId) {
        CategoryEntity category = (CategoryEntity)((Object)this.categoryDao.selectById((Serializable)((Object)categoryId)));
        if (category != null) {
            category.setCategoryParentIds(null);
            List<CategoryEntity> childrenList = this.categoryDao.queryChildren(category);
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 0; i < childrenList.size(); ++i) {
                ids.add(childrenList.get(i).getId());
            }
            this.categoryDao.deleteBatchIds(ids);
            this.contentDao.deleteEntityByCategoryIds(ids.toArray(new String[ids.size()]));
        }
    }

    private void setParentLeaf(CategoryEntity entity) {
        CategoryEntity categoryEntity = (CategoryEntity)((Object)this.getById((Serializable)((Object)entity.getId())));
        if (entity.getCategoryId() != null && !entity.getCategoryId().equals(categoryEntity.getCategoryId())) {
            CategoryEntity parent;
            if (StrUtil.isNotBlank((CharSequence)categoryEntity.getCategoryId()) && !"0".equals(categoryEntity.getCategoryId())) {
                parent = (CategoryEntity)((Object)this.getById((Serializable)((Object)categoryEntity.getCategoryId())));
                boolean leaf = parent.getLeaf();
                QueryWrapper queryWrapper = new QueryWrapper();
                parent.setLeaf(this.count((Wrapper)((QueryWrapper)queryWrapper.eq((Object)"category_id", (Object)parent.getId())).ne((Object)"id", (Object)entity.getId())) == 0);
                if (leaf != parent.getLeaf()) {
                    this.updateById((Object)parent);
                }
            }
            if (StrUtil.isNotBlank((CharSequence)entity.getCategoryId()) && !"0".equals(entity.getCategoryId()) && (parent = (CategoryEntity)((Object)this.getById((Serializable)((Object)entity.getCategoryId())))).getLeaf().booleanValue()) {
                parent.setLeaf(false);
                this.updateById((Object)parent);
            }
        }
    }

    private void setTopId(CategoryEntity entity) {
        String[] ids;
        String categoryParentId = entity.getCategoryParentIds();
        if (StrUtil.isNotBlank((CharSequence)categoryParentId) && (ids = categoryParentId.split(",")).length > 0) {
            entity.setTopId(ids[0]);
            return;
        }
        entity.setTopId("0");
    }

    @Override
    public void copyCategory(CategoryEntity category) {
        String oldId = category.getId();
        category = (CategoryEntity)((Object)this.getById((Serializable)((Object)oldId)));
        category.setId(null);
        category.setCategoryPinyin(null);
        category.setCategoryPath(null);
        this.saveEntity(category);
        this.recursionCopyChilds(oldId, category.getId());
    }

    private void recursionCopyChilds(String oldParentId, String newParentId) {
        CategoryEntity _category = new CategoryEntity();
        _category.setCategoryId(oldParentId);
        List childs = this.query(_category);
        for (CategoryEntity child : childs) {
            String childId = child.getId();
            child.setId(null);
            child.setCategoryPinyin(null);
            child.setCategoryPath(null);
            child.setCategoryId(newParentId);
            this.saveEntity(child);
            this.recursionCopyChilds(childId, child.getId());
        }
    }
}

