/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.PageUtil;
import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.cms.bean.CategoryBean;
import net.mingsoft.cms.constant.e.CategoryTypeEnum;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.mdiy.bean.PageBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.biz.impl.ModelBizImpl;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.util.ParserUtil;
import org.apache.commons.lang3.StringUtils;

public class CmsParserUtil {
    private static final String FIELD = "field";

    public static void generate(String templatePath, String targetPath, String htmlDir) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isDo", false);
        CategoryEntity column = new CategoryEntity();
        map.put("column", (Object)column);
        map.put("html", htmlDir);
        if (BasicUtil.getWebsiteApp() != null) {
            map.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
            map.put("url", BasicUtil.getWebsiteApp().getAppHostUrl());
            map.put("appId", BasicUtil.getWebsiteApp().getAppId());
        } else {
            map.put("url", BasicUtil.getUrl());
            map.put("appDir", BasicUtil.getApp().getAppDir());
        }
        String content = ParserUtil.rendering((String)templatePath, map);
        FileUtil.writeString((String)content, (String)ParserUtil.buildHtmlPath((String)targetPath, (String)htmlDir, (String)map.get("appDir").toString()), (String)"utf-8");
    }

    public static void generateList(CategoryEntity column, int articleIdTotal, String htmlDir) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        try {
            PageBean page = new PageBean();
            page.setSize(ParserUtil.getPageSize((String)column.getCategoryListUrl(), (int)20));
            page.setRcount(articleIdTotal);
            int totalPageSize = PageUtil.totalPage((int)articleIdTotal, (int)page.getSize());
            page.setTotal(totalPageSize);
            HashMap<String, Object> parserParams = new HashMap<String, Object>();
            parserParams.put("isDo", false);
            parserParams.put("html", htmlDir);
            parserParams.put("pageTag", page);
            if (BasicUtil.getWebsiteApp() != null) {
                parserParams.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
                parserParams.put("url", BasicUtil.getWebsiteApp().getAppHostUrl());
                parserParams.put("appId", BasicUtil.getWebsiteApp().getAppId());
            } else {
                parserParams.put("url", BasicUtil.getUrl());
                parserParams.put("appDir", BasicUtil.getApp().getAppDir());
            }
            parserParams.put("column", (Object)column);
            parserParams.put(FIELD, (Object)column);
            ModelEntity contentModel = null;
            if (column.getMdiyModelId() != null) {
                contentModel = (ModelEntity)((ModelBizImpl)SpringUtil.getBean(ModelBizImpl.class)).getEntity(column.getMdiyModelId().intValue());
            }
            if (contentModel != null) {
                parserParams.put("tableName", contentModel.getModelTableName());
            }
            int pageNo = 1;
            if (totalPageSize <= 0) {
                String columnListPath = ParserUtil.buildHtmlPath((String)(column.getCategoryPath() + File.separator + "index"), (String)htmlDir, (String)parserParams.get("appDir").toString());
                page.setPageNo(pageNo);
                String read = ParserUtil.rendering((String)(File.separator + column.getCategoryListUrl()), parserParams);
                FileUtil.writeString((String)read, (String)columnListPath, (String)"utf-8");
            } else {
                for (int i = 0; i < totalPageSize; ++i) {
                    String columnListPath = i == 0 ? ParserUtil.buildHtmlPath((String)(column.getCategoryPath() + File.separator + "index"), (String)htmlDir, (String)parserParams.get("appDir").toString()) : ParserUtil.buildHtmlPath((String)(column.getCategoryPath() + File.separator + "list-" + pageNo), (String)htmlDir, (String)parserParams.get("appDir").toString());
                    page.setPageNo(pageNo);
                    String read = ParserUtil.rendering((String)(File.separator + column.getCategoryListUrl()), parserParams);
                    FileUtil.writeString((String)read, (String)columnListPath, (String)"utf-8");
                    ++pageNo;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateBasic(List<CategoryBean> articleIdList, String htmlDir) {
        HashMap<String, Object> parserParams = new HashMap<String, Object>();
        parserParams.put("isDo", false);
        if (BasicUtil.getWebsiteApp() != null) {
            parserParams.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
            parserParams.put("url", BasicUtil.getWebsiteApp().getAppHostUrl());
            parserParams.put("appId", BasicUtil.getWebsiteApp().getAppId());
        } else {
            parserParams.put("url", BasicUtil.getUrl());
            parserParams.put("appDir", BasicUtil.getApp().getAppDir());
        }
        parserParams.put("html", htmlDir);
        HashMap<Integer, String> contentModelMap = new HashMap<Integer, String>();
        ModelEntity contentModel = null;
        ArrayList<String> generateIds = new ArrayList<String>();
        int artId = 0;
        while (artId < articleIdList.size()) {
            CategoryBean categoryBean = articleIdList.get(artId);
            String writePath = null;
            PageBean page = new PageBean();
            String articleId = categoryBean.getArticleId();
            String articleColumnPath = categoryBean.getCategoryPath();
            String categoryParentId = categoryBean.getId();
            if (StringUtils.isNotBlank((CharSequence)categoryBean.getCategoryParentIds())) {
                categoryParentId = categoryParentId + ',' + categoryBean.getCategoryParentIds();
            }
            String columnUrl = categoryBean.getCategoryUrl();
            Integer columnContentModelId = null;
            if (articleIdList.get(artId).getMdiyModelId() != null && categoryBean.getMdiyModelId() > 0) {
                columnContentModelId = categoryBean.getMdiyModelId();
            }
            if (generateIds.contains(articleId)) {
                ++artId;
                continue;
            }
            if (!FileUtil.exist((String)ParserUtil.buildTempletPath((String)columnUrl)) || categoryBean.getId() == null || categoryBean.getCategoryType() == null) {
                ++artId;
                continue;
            }
            generateIds.add(articleId);
            writePath = categoryBean.getCategoryType().equals(CategoryTypeEnum.COVER.toString()) ? ParserUtil.buildHtmlPath((String)(articleColumnPath + File.separator + "index"), (String)htmlDir, (String)parserParams.get("appDir").toString()) : ParserUtil.buildHtmlPath((String)(articleColumnPath + File.separator + articleId), (String)htmlDir, (String)parserParams.get("appDir").toString());
            parserParams.put("column", (Object)categoryBean);
            if (columnContentModelId != null) {
                if (contentModelMap.containsKey(columnContentModelId)) {
                    parserParams.put("tableName", contentModel.getModelTableName());
                } else {
                    contentModel = (ModelEntity)((IModelBiz)SpringUtil.getBean(IModelBiz.class)).getEntity(columnContentModelId.intValue());
                    contentModelMap.put(columnContentModelId, contentModel.getModelTableName());
                    parserParams.put("tableName", contentModel.getModelTableName());
                }
            }
            parserParams.put("id", articleId);
            if (artId > 0) {
                CategoryBean preCaBean = articleIdList.get(artId - 1);
                page.setPreId(preCaBean.getArticleId());
            }
            if (artId + 1 < articleIdList.size()) {
                CategoryBean nextCaBean = articleIdList.get(artId + 1);
                page.setNextId(nextCaBean.getArticleId());
            }
            parserParams.put("pageTag", page);
            String finalWritePath = writePath;
            HashMap cloneMap = CollUtil.newHashMap();
            cloneMap.putAll(parserParams);
            HttpServletRequest request = SpringUtil.getRequest();
            String content = null;
            try {
                content = ParserUtil.rendering((String)columnUrl, (Map)cloneMap);
                FileUtil.writeString((String)content, (String)finalWritePath, (String)"utf-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++artId;
        }
    }
}

