/*
 * Decompiled with CFR 0.152.
 */
package com.ld.zxw.Documents;

import java.util.Date;
import org.apache.lucene.document.BinaryPoint;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class Documents {
    private Document document = new Document();

    public void put(String key, Object val, String type, float boost) {
        if (val != null) {
            if (type.equals("date")) {
                Date time = (Date)val;
                this.addField(key, Long.toString(time.getTime()), type, boost);
            } else {
                this.addField(key, val.toString(), type, boost);
            }
        } else {
            return;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void addField(String name, String value, String type, float boost) {
        switch (type) {
            case "int": {
                int point_i = Integer.parseInt(value);
                this.document.add((IndexableField)new IntPoint(name, new int[]{point_i}));
                this.document.add((IndexableField)new StoredField(name, point_i));
                this.document.add((IndexableField)new NumericDocValuesField(name, (long)point_i));
                break;
            }
            case "integer": {
                int point_it = Integer.parseInt(value);
                this.document.add((IndexableField)new IntPoint(name, new int[]{point_it}));
                this.document.add((IndexableField)new StoredField(name, point_it));
                this.document.add((IndexableField)new NumericDocValuesField(name, (long)point_it));
                break;
            }
            case "long": {
                long point_l = Long.valueOf(value);
                this.document.add((IndexableField)new LongPoint(name, new long[]{point_l}));
                this.document.add((IndexableField)new StoredField(name, point_l));
                this.document.add((IndexableField)new NumericDocValuesField(name, point_l));
                break;
            }
            case "date": {
                long point_date = Long.valueOf(value);
                this.document.add((IndexableField)new LongPoint(name, new long[]{point_date}));
                this.document.add((IndexableField)new StoredField(name, point_date));
                this.document.add((IndexableField)new NumericDocValuesField(name, point_date));
                break;
            }
            case "float": {
                float point_f = Float.valueOf(value).floatValue();
                this.document.add((IndexableField)new FloatPoint(name, new float[]{point_f}));
                this.document.add((IndexableField)new StoredField(name, point_f));
                break;
            }
            case "binary": {
                byte[] point_b = value.getBytes();
                this.document.add((IndexableField)new BinaryPoint(name, (byte[][])new byte[][]{point_b}));
                this.document.add((IndexableField)new StoredField(name, point_b));
                break;
            }
            case "double": {
                double point_d = Double.valueOf(value);
                this.document.add((IndexableField)new DoublePoint(name, new double[]{point_d}));
                this.document.add((IndexableField)new StoredField(name, point_d));
                break;
            }
            case "string": {
                this.document.add((IndexableField)new StringField(name, value, Field.Store.YES));
                this.document.add((IndexableField)new SortedDocValuesField(name, new BytesRef((CharSequence)value)));
                break;
            }
            case "text": {
                TextField textField = new TextField(name, value, Field.Store.YES);
                textField.setBoost(boost);
                this.document.add((IndexableField)textField);
            }
        }
    }
}

