/*
 * Decompiled with CFR 0.152.
 */
package com.ld.zxw.core;

import com.ld.zxw.core.CoreConfig;
import com.ld.zxw.core.LucenePlus;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ConfigFilter
implements Filter {
    private LucenePlus lucenePlus;
    private CoreConfig coreConfig;

    public void destroy() {
        this.lucenePlus.stop();
    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain arg2) throws IOException, ServletException {
        this.lucenePlus.commit();
        arg2.doFilter(arg0, arg1);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.createJFinalConfig(filterConfig.getInitParameter("configClass"));
        this.lucenePlus = this.coreConfig.configConstant();
        this.lucenePlus.start();
    }

    protected void createJFinalConfig(String configClass) {
        if (configClass == null) {
            throw new RuntimeException("Please set configClass parameter of JFinalFilter in web.xml");
        }
        Object temp = null;
        try {
            temp = Class.forName(configClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create instance of class: " + configClass, e);
        }
        if (!(temp instanceof CoreConfig)) {
            throw new RuntimeException("Can not create instance of class: " + configClass + ". Please check the config in web.xml");
        }
        this.coreConfig = temp;
    }
}

