/*
 * Decompiled with CFR 0.152.
 */
package com.ld.zxw.service;

import com.ld.zxw.config.LuceneDataSource;
import com.ld.zxw.config.LucenePlusConfig;
import com.ld.zxw.index.IndexDao;
import com.ld.zxw.page.Page;
import com.ld.zxw.service.LuceneService;
import com.ld.zxw.util.CommonUtil;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;

public class LuceneServiceImpl
implements LuceneService {
    private LucenePlusConfig lucenePlusConfig = null;
    private IndexDao indexDao;

    public LuceneServiceImpl(String sourceKey) {
        this.lucenePlusConfig = LuceneDataSource.build().dataSource.get(sourceKey);
        this.indexDao = IndexDao.build(this.lucenePlusConfig);
    }

    @Override
    public <T> void saveObj(List<T> objs) throws IOException {
        this.indexDao.saveIndex(CommonUtil.turnDoc(objs, this.lucenePlusConfig));
    }

    @Override
    public <T> void saveObj(T objs) throws IOException {
        this.indexDao.saveIndex(CommonUtil.turnDoc(objs, this.lucenePlusConfig));
    }

    @Override
    public <T> void saveDocument(List<Document> documents) throws IOException {
        this.indexDao.saveIndex(documents);
    }

    @Override
    public <T> void saveDocument(Document document) throws IOException {
        this.indexDao.saveIndex(document);
    }

    @Override
    public void delAll() throws IOException {
        this.indexDao.delAll();
    }

    @Override
    public void delKey(Term term) throws IOException {
        this.indexDao.deletekey(term);
    }

    @Override
    public void delKey(Query query) throws IOException {
        this.indexDao.deletekey(query);
    }

    @Override
    public <T> void updateObj(List<T> objs, Term term) throws IOException {
        this.indexDao.updateIndex(CommonUtil.turnDoc(objs, this.lucenePlusConfig), term);
    }

    @Override
    public <T> void updateObj(T obj, Term term) throws IOException {
        this.indexDao.updateIndex(CommonUtil.turnDoc(obj, this.lucenePlusConfig), term);
    }

    @Override
    public void updateDocument(List<Document> docs, Term term) throws IOException {
        this.indexDao.updateIndex(docs, term);
    }

    @Override
    public void updateDocument(Document doc, Term term) throws IOException {
        this.indexDao.updateIndex(doc, term);
    }

    @Override
    public <T> List<T> findList(Query query, Class<T> obj, int num, Sort sort) throws IOException, InvalidTokenOffsetsException {
        return this.indexDao.findList(query, obj, num, sort);
    }

    @Override
    public <T> Page<T> findList(Query query, int pageNumber, int pageSize, Class<T> obj, Sort sort) throws IOException, InvalidTokenOffsetsException {
        return this.indexDao.findList(query, pageNumber, pageSize, obj, sort);
    }
}

