/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import com.google.common.collect.Lists;
import com.ld.zxw.config.LuceneDataSource;
import com.ld.zxw.config.LucenePlusConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.wltea.analyzer.dic.DictSegment;
import org.wltea.analyzer.dic.Hit;

public class Dictionary {
    private Logger log = Logger.getLogger(Dictionary.class);
    private static Dictionary singleton;
    private DictSegment _MainDict;
    private DictSegment _StopWordDict;
    private DictSegment _QuantifierDict;

    private Dictionary(LucenePlusConfig LucenePlusConfig2) {
        this.loadMainDict();
        if (LuceneDataSource.build().DynamicDictionary) {
            this.log.info((Object)"Dictionary \u52a0\u8f7d\u52a8\u6001\u8bcd\u5178");
            this.loadDynamicDictionary("ext");
            this.loadDynamicDictionary("stopword");
        } else {
            this.log.info((Object)"Dictionary \u52a0\u8f7d\u9759\u6001\u8bcd\u5178");
            String extWordPath = null;
            String stopWordPath = null;
            if (LucenePlusConfig2 != null) {
                extWordPath = LucenePlusConfig2.getExtWordPath();
                stopWordPath = LucenePlusConfig2.getStopWordPath();
            }
            this.loadExtDict(extWordPath);
            this.loadStopWordDict(stopWordPath);
        }
        this.loadQuantifierDict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Dictionary initial(LucenePlusConfig lucenePlusConfig) {
        if (singleton != null) return singleton;
        Class<Dictionary> clazz = Dictionary.class;
        synchronized (Dictionary.class) {
            if (singleton != null) return singleton;
            singleton = new Dictionary(lucenePlusConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public static Dictionary getSingleton() {
        if (singleton == null) {
            throw new IllegalStateException("\u8bcd\u5178\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528initial\u65b9\u6cd5");
        }
        return singleton;
    }

    public void addWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.fillSegment(word.trim().toLowerCase().toCharArray());
            }
        }
    }

    public void disableWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.disableSegment(word.trim().toLowerCase().toCharArray());
            }
        }
    }

    public Hit matchInMainDict(char[] charArray) {
        return Dictionary.singleton._MainDict.match(charArray);
    }

    public Hit matchInMainDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._MainDict.match(charArray, begin, length);
    }

    public Hit matchInQuantifierDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._QuantifierDict.match(charArray, begin, length);
    }

    public Hit matchWithHit(char[] charArray, int currentIndex, Hit matchedHit) {
        DictSegment ds = matchedHit.getMatchedDictSegment();
        return ds.match(charArray, currentIndex, 1, matchedHit);
    }

    public boolean isStopWord(char[] charArray, int begin, int length) {
        return Dictionary.singleton._StopWordDict.match(charArray, begin, length).isMatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMainDict() {
        this._MainDict = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = this.getDic("main2012.dic");
        if (is == null) {
            throw new RuntimeException("Main Dictionary not found!!!");
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._MainDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            System.err.println("Main Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadDynamicDictionary(String type) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtDict(String path) {
        if (path == null) {
            this.log.info((Object)"\u8b66\u544a:\u6ca1\u6709\u8bbe\u7f6e\u6269\u5c55\u542f\u52a8\u8bcd\u5e93");
        } else {
            ArrayList list = Lists.newArrayList();
            this.getExtend(list, path);
            if (!list.isEmpty()) {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    InputStream is = (InputStream)list.get(i);
                    if (is == null) continue;
                    try {
                        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
                        String theWord = null;
                        do {
                            if ((theWord = br.readLine()) == null) continue;
                            this._MainDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
                        } while (theWord != null);
                        continue;
                    }
                    catch (IOException ioe) {
                        System.err.println("Extension Dictionary loading exception.");
                        ioe.printStackTrace();
                        continue;
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                                is = null;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                this.log.info((Object)("\u8b66\u544a:" + path + "-\u8be5\u76ee\u5f55\u6ca1\u6709\u4efb\u4f55 .dic \u7ed3\u5c3e\u7684\u6587\u4ef6"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStopWordDict(String path) {
        this._StopWordDict = new DictSegment(Character.valueOf('\u0000'));
        if (path == null) {
            this.log.info((Object)"\u8b66\u544a:\u6ca1\u6709\u8bbe\u7f6e\u6269\u5c55\u505c\u7528\u8bcd\u5e93");
        } else {
            ArrayList list = Lists.newArrayList();
            this.getExtend(list, path);
            if (!list.isEmpty()) {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    InputStream is = (InputStream)list.get(i);
                    if (is == null) continue;
                    try {
                        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
                        String theWord = null;
                        do {
                            if ((theWord = br.readLine()) == null) continue;
                            this._StopWordDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
                        } while (theWord != null);
                        continue;
                    }
                    catch (IOException ioe) {
                        System.err.println("Extension Stop word Dictionary loading exception.");
                        ioe.printStackTrace();
                        continue;
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                                is = null;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                this.log.info((Object)("\u8b66\u544a:" + path + "-\u8be5\u76ee\u5f55\u6ca1\u6709\u4efb\u4f55 .dic \u7ed3\u5c3e\u7684\u6587\u4ef6"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQuantifierDict() {
        this._QuantifierDict = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = this.getDic("quantifier.dic");
        if (is == null) {
            throw new RuntimeException("Quantifier Dictionary not found!!!");
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._QuantifierDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            System.err.println("Quantifier Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public InputStream getDic(String fileName) {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream("/dic/" + fileName);
        }
        catch (Exception e) {
            System.out.println("\u627e\u4e0d\u5230\u57fa\u7840\u8bcd\u5e93");
            e.printStackTrace();
        }
        System.out.println("\u52a0\u8f7d\u5185\u7f6e\u8bcd\u5e93:" + fileName);
        return in;
    }

    public void getExtend(List<InputStream> list, String path) {
        File f = new File(path);
        if (f.exists()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    this.getExtend(list, file.getAbsolutePath());
                    continue;
                }
                try {
                    if (file.exists() && file.getName().endsWith(".dic")) {
                        list.add(new FileInputStream(file));
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                System.out.println("\u6587\u4ef6\u540d:" + file.getName());
            }
        }
    }

    public static void main(String[] args) {
        String jkds = "djksjd.jdsjd.dic";
        System.out.println(jkds.endsWith(".dics"));
    }
}

