/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.indexes.AbstractIndexCreationTask;
import net.ravendb.client.documents.indexes.IndexCreation;
import net.ravendb.client.documents.indexes.IndexDefinition;
import net.ravendb.client.documents.operations.MaintenanceOperationExecutor;
import net.ravendb.client.documents.operations.OperationExecutor;
import net.ravendb.client.documents.operations.indexes.PutIndexesOperation;
import net.ravendb.client.documents.session.AfterStoreEventArgs;
import net.ravendb.client.documents.session.BeforeDeleteEventArgs;
import net.ravendb.client.documents.session.BeforeQueryExecutedEventArgs;
import net.ravendb.client.documents.session.BeforeStoreEventArgs;
import net.ravendb.client.documents.session.IDocumentSession;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;
import net.ravendb.client.documents.session.SessionOptions;
import net.ravendb.client.http.RequestExecutor;
import net.ravendb.client.primitives.EventArgs;
import net.ravendb.client.primitives.EventHandler;
import net.ravendb.client.primitives.VoidArgs;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class DocumentStoreBase
implements IDocumentStore {
    private final List<EventHandler<BeforeStoreEventArgs>> onBeforeStore = new ArrayList<EventHandler<BeforeStoreEventArgs>>();
    private final List<EventHandler<AfterStoreEventArgs>> onAfterStore = new ArrayList<EventHandler<AfterStoreEventArgs>>();
    private final List<EventHandler<BeforeDeleteEventArgs>> onBeforeDelete = new ArrayList<EventHandler<BeforeDeleteEventArgs>>();
    private final List<EventHandler<BeforeQueryExecutedEventArgs>> onBeforeQueryExecuted = new ArrayList<EventHandler<BeforeQueryExecutedEventArgs>>();
    protected boolean disposed;
    private DocumentConventions conventions;
    protected String[] urls = new String[0];
    protected boolean initialized;
    private KeyStore _certificate;
    protected String database;

    protected DocumentStoreBase() {
    }

    @Override
    public abstract void close();

    @Override
    public abstract void addAfterCloseListener(EventHandler<VoidArgs> var1);

    @Override
    public abstract void removeAfterCloseListener(EventHandler<VoidArgs> var1);

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public abstract String getIdentifier();

    @Override
    public abstract void setIdentifier(String var1);

    @Override
    public abstract IDocumentStore initialize();

    @Override
    public abstract IDocumentSession openSession();

    @Override
    public abstract IDocumentSession openSession(String var1);

    @Override
    public abstract IDocumentSession openSession(SessionOptions var1);

    @Override
    public void executeIndex(AbstractIndexCreationTask task) {
        this.executeIndex(task, null);
    }

    @Override
    public void executeIndex(AbstractIndexCreationTask task, String database) {
        this.assertInitialized();
        task.execute(this, this.conventions, database);
    }

    @Override
    public void executeIndexes(List<AbstractIndexCreationTask> tasks) {
        this.executeIndexes(tasks, null);
    }

    @Override
    public void executeIndexes(List<AbstractIndexCreationTask> tasks, String database) {
        this.assertInitialized();
        IndexDefinition[] indexesToAdd = IndexCreation.createIndexesToAdd(tasks, this.conventions);
        this.maintenance().forDatabase((String)ObjectUtils.firstNonNull((Object[])new String[]{database, this.getDatabase()})).send(new PutIndexesOperation(indexesToAdd));
    }

    @Override
    public DocumentConventions getConventions() {
        if (this.conventions == null) {
            this.conventions = new DocumentConventions();
        }
        return this.conventions;
    }

    public void setConventions(DocumentConventions conventions) {
        this.conventions = conventions;
    }

    @Override
    public String[] getUrls() {
        return this.urls;
    }

    public void setUrls(String[] value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException("Urls cannot contain null");
            }
            try {
                new URL(value[i]);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("The url '" + value[i] + "' is not valid");
            }
            value[i] = StringUtils.stripEnd((String)value[i], (String)"/");
        }
        this.urls = value;
    }

    protected void ensureNotClosed() {
        if (this.disposed) {
            throw new IllegalStateException("The document store has already been disposed and cannot be used");
        }
    }

    protected void assertInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("You cannot open a session or access the database commands before initializing the document store. Did you forget calling initialize()?");
        }
    }

    @Override
    public void addBeforeStoreListener(EventHandler<BeforeStoreEventArgs> handler) {
        this.onBeforeStore.add(handler);
    }

    @Override
    public void removeBeforeStoreListener(EventHandler<BeforeStoreEventArgs> handler) {
        this.onBeforeStore.remove(handler);
    }

    @Override
    public void addAfterStoreListener(EventHandler<AfterStoreEventArgs> handler) {
        this.onAfterStore.add(handler);
    }

    @Override
    public void removeAfterStoreListener(EventHandler<AfterStoreEventArgs> handler) {
        this.onAfterStore.remove(handler);
    }

    @Override
    public void addBeforeDeleteListener(EventHandler<BeforeDeleteEventArgs> handler) {
        this.onBeforeDelete.add(handler);
    }

    @Override
    public void removeBeforeDeleteListener(EventHandler<BeforeDeleteEventArgs> handler) {
        this.onBeforeDelete.remove(handler);
    }

    @Override
    public void addBeforeQueryExecutedListener(EventHandler<BeforeQueryExecutedEventArgs> handler) {
        this.onBeforeQueryExecuted.add(handler);
    }

    @Override
    public void removeBeforeQueryExecutedListener(EventHandler<BeforeQueryExecutedEventArgs> handler) {
        this.onBeforeQueryExecuted.remove(handler);
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public KeyStore getCertificate() {
        return this._certificate;
    }

    public void setCertificate(KeyStore certificate) {
        if (this.initialized) {
            throw new IllegalStateException("You cannot change the certificate after the document store was initialized");
        }
        this._certificate = certificate;
    }

    @Override
    public abstract RequestExecutor getRequestExecutor();

    @Override
    public abstract RequestExecutor getRequestExecutor(String var1);

    protected void registerEvents(InMemoryDocumentSessionOperations session) {
        for (EventHandler<BeforeStoreEventArgs> eventHandler : this.onBeforeStore) {
            session.addBeforeStoreListener(eventHandler);
        }
        for (EventHandler<EventArgs> eventHandler : this.onAfterStore) {
            session.addAfterStoreListener(eventHandler);
        }
        for (EventHandler<EventArgs> eventHandler : this.onBeforeDelete) {
            session.addBeforeDeleteListener(eventHandler);
        }
        for (EventHandler<EventArgs> eventHandler : this.onBeforeQueryExecuted) {
            session.addBeforeQueryExecutedListener(eventHandler);
        }
    }

    @Override
    public abstract MaintenanceOperationExecutor maintenance();

    @Override
    public abstract OperationExecutor operations();
}

