/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.commands;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import net.ravendb.client.documents.commands.batches.PutResult;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.Reference;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class PutDocumentCommand
extends RavenCommand<PutResult> {
    private final String _id;
    private final String _changeVector;
    private final ObjectNode _document;

    public PutDocumentCommand(String id, String changeVector, ObjectNode document) {
        super(PutResult.class);
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this._id = id;
        this._changeVector = changeVector;
        this._document = document;
    }

    @Override
    public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
        url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/docs?id=" + this.urlEncode(this._id);
        HttpPut request = new HttpPut();
        request.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
            try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                generator.writeTree((TreeNode)this._document);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, ContentType.APPLICATION_JSON));
        this.addChangeVectorIfNotNull(this._changeVector, (HttpRequestBase)request);
        return request;
    }

    @Override
    public void setResponse(String response, boolean fromCache) throws IOException {
        this.result = this.mapper.readValue(response, PutResult.class);
    }

    @Override
    public boolean isReadRequest() {
        return false;
    }
}

