/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.identity;

import java.lang.reflect.Field;
import java.util.function.Function;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.primitives.Reference;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GenerateEntityIdOnTheClient {
    private final DocumentConventions _conventions;
    private final Function<Object, String> _generateId;

    public GenerateEntityIdOnTheClient(DocumentConventions conventions, Function<Object, String> generateId) {
        this._conventions = conventions;
        this._generateId = generateId;
    }

    private Field getIdentityProperty(Class<?> entityType) {
        return this._conventions.getIdentityProperty(entityType);
    }

    public boolean tryGetIdFromInstance(Object entity, Reference<String> idHolder) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        try {
            Object value;
            Field identityProperty = this.getIdentityProperty(entity.getClass());
            if (identityProperty != null && (value = FieldUtils.readField((Field)identityProperty, (Object)entity, (boolean)true)) instanceof String) {
                idHolder.value = (String)value;
                return true;
            }
            idHolder.value = null;
            return false;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getOrGenerateDocumentId(Object entity) {
        Reference<String> idHolder = new Reference<String>();
        this.tryGetIdFromInstance(entity, idHolder);
        String id = (String)idHolder.value;
        if (id == null) {
            id = this._generateId.apply(entity);
        }
        if (id != null && id.startsWith("/")) {
            throw new IllegalStateException("Cannot use value '" + id + "' as a document id because it begins with a '/'");
        }
        return id;
    }

    public String generateDocumentKeyForStorage(Object entity) {
        String id = this.getOrGenerateDocumentId(entity);
        this.trySetIdentity(entity, id);
        return id;
    }

    public void trySetIdentity(Object entity, String id) {
        Class<?> entityType = entity.getClass();
        Field identityProperty = this._conventions.getIdentityProperty(entityType);
        if (identityProperty == null) {
            return;
        }
        this.setPropertyOrField(identityProperty.getType(), entity, identityProperty, id);
    }

    private void setPropertyOrField(Class<?> propertyOrFieldType, Object entity, Field field, String id) {
        try {
            if (!String.class.equals(propertyOrFieldType)) {
                throw new IllegalArgumentException("Cannot set identity value '" + id + "' on field " + propertyOrFieldType + " because field type is not string.");
            }
            FieldUtils.writeField((Field)field, (Object)entity, (Object)id, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

