/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.identity;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.ravendb.client.documents.DocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.identity.MultiTypeHiLoIdGenerator;

public class MultiDatabaseHiLoIdGenerator {
    protected final DocumentStore store;
    protected final DocumentConventions conventions;
    private final ConcurrentMap<String, MultiTypeHiLoIdGenerator> _generators = new ConcurrentHashMap<String, MultiTypeHiLoIdGenerator>();

    public MultiDatabaseHiLoIdGenerator(DocumentStore store, DocumentConventions conventions) {
        this.store = store;
        this.conventions = conventions;
    }

    public String generateDocumentId(String dbName, Object entity) {
        String db = dbName != null ? dbName : this.store.getDatabase();
        MultiTypeHiLoIdGenerator generator = this._generators.computeIfAbsent(db, x -> this.generateMultiTypeHiLoFunc((String)x));
        return generator.generateDocumentId(entity);
    }

    public MultiTypeHiLoIdGenerator generateMultiTypeHiLoFunc(String dbName) {
        return new MultiTypeHiLoIdGenerator(this.store, dbName, this.conventions);
    }

    public void returnUnusedRange() {
        for (MultiTypeHiLoIdGenerator generator : this._generators.values()) {
            generator.returnUnusedRange();
        }
    }
}

