/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.identity;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.ravendb.client.documents.DocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.identity.HiLoIdGenerator;
import org.apache.commons.lang3.StringUtils;

public class MultiTypeHiLoIdGenerator {
    private final Object _generatorLock = new Object();
    private final ConcurrentMap<String, HiLoIdGenerator> _idGeneratorsByTag = new ConcurrentHashMap<String, HiLoIdGenerator>();
    protected final DocumentStore store;
    protected final String dbName;
    protected final DocumentConventions conventions;

    public MultiTypeHiLoIdGenerator(DocumentStore store, String dbName, DocumentConventions conventions) {
        this.store = store;
        this.dbName = dbName;
        this.conventions = conventions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDocumentId(Object entity) {
        String typeTagName = this.conventions.getCollectionName(entity);
        if (StringUtils.isEmpty((CharSequence)typeTagName)) {
            return null;
        }
        String tag = this.conventions.getTransformClassCollectionNameToDocumentIdPrefix().apply(typeTagName);
        HiLoIdGenerator value = (HiLoIdGenerator)this._idGeneratorsByTag.get(tag);
        if (value != null) {
            return value.generateDocumentId(entity);
        }
        Object object = this._generatorLock;
        synchronized (object) {
            value = (HiLoIdGenerator)this._idGeneratorsByTag.get(tag);
            if (value != null) {
                return value.generateDocumentId(entity);
            }
            value = this.createGeneratorFor(tag);
            this._idGeneratorsByTag.put(tag, value);
        }
        return value.generateDocumentId(entity);
    }

    protected HiLoIdGenerator createGeneratorFor(String tag) {
        return new HiLoIdGenerator(tag, this.store, this.dbName, this.conventions.getIdentityPartsSeparator());
    }

    public void returnUnusedRange() {
        for (HiLoIdGenerator generator : this._idGeneratorsByTag.values()) {
            generator.returnUnusedRange();
        }
    }
}

