/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.indexes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.indexes.FieldIndexing;
import net.ravendb.client.documents.indexes.FieldStorage;
import net.ravendb.client.documents.indexes.FieldTermVector;
import net.ravendb.client.documents.indexes.IndexDefinition;
import net.ravendb.client.documents.indexes.IndexDefinitionBuilder;
import net.ravendb.client.documents.indexes.IndexLockMode;
import net.ravendb.client.documents.indexes.IndexPriority;
import net.ravendb.client.documents.indexes.spatial.SpatialOptions;
import net.ravendb.client.documents.indexes.spatial.SpatialOptionsFactory;
import net.ravendb.client.documents.operations.indexes.PutIndexesOperation;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractIndexCreationTask {
    protected String map;
    protected String reduce;
    private DocumentConventions conventions;
    protected Map<String, String> additionalSources;
    protected IndexPriority priority;
    protected IndexLockMode lockMode;
    protected final Map<String, FieldStorage> storesStrings = new HashMap<String, FieldStorage>();
    protected final Map<String, FieldIndexing> indexesStrings = new HashMap<String, FieldIndexing>();
    protected final Map<String, String> analyzersStrings = new HashMap<String, String>();
    protected final Set<String> indexSuggestions = new HashSet<String>();
    protected final Map<String, FieldTermVector> termVectorsStrings = new HashMap<String, FieldTermVector>();
    protected final Map<String, SpatialOptions> spatialOptionsStrings = new HashMap<String, SpatialOptions>();
    protected String outputReduceToCollection;

    public Map<String, String> getAdditionalSources() {
        return this.additionalSources;
    }

    public void setAdditionalSources(Map<String, String> additionalSources) {
        this.additionalSources = additionalSources;
    }

    public IndexDefinition createIndexDefinition() {
        if (this.conventions == null) {
            this.conventions = new DocumentConventions();
        }
        IndexDefinitionBuilder indexDefinitionBuilder = new IndexDefinitionBuilder(this.getIndexName());
        indexDefinitionBuilder.setIndexesStrings(this.indexesStrings);
        indexDefinitionBuilder.setAnalyzersStrings(this.analyzersStrings);
        indexDefinitionBuilder.setMap(this.map);
        indexDefinitionBuilder.setReduce(this.reduce);
        indexDefinitionBuilder.setStoresStrings(this.storesStrings);
        indexDefinitionBuilder.setSuggestionsOptions(this.indexSuggestions);
        indexDefinitionBuilder.setTermVectorsStrings(this.termVectorsStrings);
        indexDefinitionBuilder.setSpatialIndexesStrings(this.spatialOptionsStrings);
        indexDefinitionBuilder.setOutputReduceToCollection(this.outputReduceToCollection);
        indexDefinitionBuilder.setAdditionalSources(this.getAdditionalSources());
        return indexDefinitionBuilder.toIndexDefinition(this.conventions);
    }

    public boolean isMapReduce() {
        return this.reduce != null;
    }

    public String getIndexName() {
        return this.getClass().getSimpleName().replaceAll("_", "/");
    }

    public DocumentConventions getConventions() {
        return this.conventions;
    }

    public void setConventions(DocumentConventions conventions) {
        this.conventions = conventions;
    }

    public IndexPriority getPriority() {
        return this.priority;
    }

    public void setPriority(IndexPriority priority) {
        this.priority = priority;
    }

    public IndexLockMode getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(IndexLockMode lockMode) {
        this.lockMode = lockMode;
    }

    public void execute(IDocumentStore store) {
        store.executeIndex(this);
    }

    public void execute(IDocumentStore store, DocumentConventions conventions) {
        this.execute(store, conventions, null);
    }

    public void execute(IDocumentStore store, DocumentConventions conventions, String database) {
        this.putIndex(store, conventions, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIndex(IDocumentStore store, DocumentConventions conventions, String database) {
        DocumentConventions oldConventions = this.getConventions();
        try {
            this.setConventions((DocumentConventions)ObjectUtils.firstNonNull((Object[])new DocumentConventions[]{conventions, this.getConventions(), store.getConventions()}));
            IndexDefinition indexDefinition = this.createIndexDefinition();
            indexDefinition.setName(this.getIndexName());
            if (this.lockMode != null) {
                indexDefinition.setLockMode(this.lockMode);
            }
            if (this.priority != null) {
                indexDefinition.setPriority(this.priority);
            }
            store.maintenance().forDatabase((String)ObjectUtils.firstNonNull((Object[])new String[]{database, store.getDatabase()})).send(new PutIndexesOperation(indexDefinition));
        }
        finally {
            this.setConventions(oldConventions);
        }
    }

    protected void index(String field, FieldIndexing indexing) {
        this.indexesStrings.put(field, indexing);
    }

    protected void spatial(String field, Function<SpatialOptionsFactory, SpatialOptions> indexing) {
        this.spatialOptionsStrings.put(field, indexing.apply(new SpatialOptionsFactory()));
    }

    protected void storeAllFields(FieldStorage storage) {
        this.storesStrings.put("__all_fields", storage);
    }

    protected void store(String field, FieldStorage storage) {
        this.storesStrings.put(field, storage);
    }

    protected void analyze(String field, String analyzer) {
        this.analyzersStrings.put(field, analyzer);
    }

    protected void termVector(String field, FieldTermVector termVector) {
        this.termVectorsStrings.put(field, termVector);
    }

    protected void suggestion(String field) {
        this.indexSuggestions.add(field);
    }
}

