/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.indexes.spatial;

import net.ravendb.client.documents.indexes.spatial.SpatialFieldType;
import net.ravendb.client.documents.indexes.spatial.SpatialSearchStrategy;
import net.ravendb.client.documents.indexes.spatial.SpatialUnits;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SpatialOptions {
    public static final int DEFAULT_GEOHASH_LEVEL = 9;
    public static final int DEFAULT_QUAD_TREE_LEVEL = 23;
    private SpatialFieldType type;
    private SpatialSearchStrategy strategy;
    private int maxTreeLevel;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private SpatialUnits units;

    public SpatialOptions() {
        this.type = SpatialFieldType.GEOGRAPHY;
        this.strategy = SpatialSearchStrategy.GEOHASH_PREFIX_TREE;
        this.maxTreeLevel = 9;
        this.minX = -180.0;
        this.maxX = 180.0;
        this.minY = -90.0;
        this.maxY = 90.0;
        this.units = SpatialUnits.KILOMETERS;
    }

    public SpatialOptions(SpatialOptions options) {
        this.type = options.type;
        this.strategy = options.strategy;
        this.maxTreeLevel = options.maxTreeLevel;
        this.minX = options.minX;
        this.maxX = options.maxX;
        this.minY = options.minY;
        this.maxY = options.maxY;
        this.units = options.units;
    }

    public SpatialFieldType getType() {
        return this.type;
    }

    public void setType(SpatialFieldType type) {
        this.type = type;
    }

    public SpatialSearchStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(SpatialSearchStrategy strategy) {
        this.strategy = strategy;
    }

    public int getMaxTreeLevel() {
        return this.maxTreeLevel;
    }

    public void setMaxTreeLevel(int maxTreeLevel) {
        this.maxTreeLevel = maxTreeLevel;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public SpatialUnits getUnits() {
        return this.units;
    }

    public void setUnits(SpatialUnits units) {
        this.units = units;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpatialOptions other = (SpatialOptions)obj;
        boolean bl = result = this.type == other.getType() && this.strategy == other.strategy;
        if (this.type == SpatialFieldType.GEOGRAPHY) {
            boolean bl2 = result = result && this.units == other.units;
        }
        if (this.strategy != SpatialSearchStrategy.BOUNDING_BOX) {
            boolean bl3 = result = result && this.maxTreeLevel == other.maxTreeLevel;
            if (this.type == SpatialFieldType.CARTESIAN) {
                result = result && this.minX == other.minX && this.maxX == other.maxX && this.minY == other.minY && this.maxY == other.maxY;
            }
        }
        return result;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.type);
        builder.append((Object)this.strategy);
        if (this.type == SpatialFieldType.GEOGRAPHY) {
            builder.append(this.units.hashCode());
        }
        if (this.strategy != SpatialSearchStrategy.BOUNDING_BOX) {
            builder.append(this.maxTreeLevel);
            if (this.type == SpatialFieldType.CARTESIAN) {
                builder.append(this.minX).append(this.maxX).append(this.minY).append(this.maxY);
            }
        }
        return builder.hashCode();
    }
}

