/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.indexes.spatial;

import net.ravendb.client.documents.indexes.spatial.SpatialFieldType;
import net.ravendb.client.documents.indexes.spatial.SpatialOptions;
import net.ravendb.client.documents.indexes.spatial.SpatialSearchStrategy;
import net.ravendb.client.documents.indexes.spatial.SpatialUnits;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SpatialOptionsFactory {
    public GeographySpatialOptionsFactory getGeography() {
        return new GeographySpatialOptionsFactory();
    }

    public CartesianSpatialOptionsFactory getCartesian() {
        return new CartesianSpatialOptionsFactory();
    }

    public static class SpatialBounds {
        private double minX;
        private double maxX;
        private double minY;
        private double maxY;

        public double getMinX() {
            return this.minX;
        }

        public void setMinX(double minX) {
            this.minX = minX;
        }

        public double getMaxX() {
            return this.maxX;
        }

        public void setMaxX(double maxX) {
            this.maxX = maxX;
        }

        public double getMinY() {
            return this.minY;
        }

        public void setMinY(double minY) {
            this.minY = minY;
        }

        public double getMaxY() {
            return this.maxY;
        }

        public void setMaxY(double maxY) {
            this.maxY = maxY;
        }

        public SpatialBounds(double minX, double minY, double maxX, double maxY) {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.maxX).append(this.maxY).append(this.minX).append(this.minY).hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpatialBounds other = (SpatialBounds)obj;
            return new EqualsBuilder().append(this.maxX, other.maxX).append(this.maxY, other.maxY).append(this.minX, other.minX).append(this.minY, other.minY).isEquals();
        }
    }

    public static class CartesianSpatialOptionsFactory {
        public SpatialOptions boundingBoxIndex() {
            SpatialOptions opts = new SpatialOptions();
            opts.setType(SpatialFieldType.CARTESIAN);
            opts.setStrategy(SpatialSearchStrategy.BOUNDING_BOX);
            return opts;
        }

        public SpatialOptions quadPrefixTreeIndex(int maxTreeLevel, SpatialBounds bounds) {
            if (maxTreeLevel == 0) {
                throw new IllegalArgumentException("maxTreeLevel");
            }
            SpatialOptions opts = new SpatialOptions();
            opts.setType(SpatialFieldType.CARTESIAN);
            opts.setMaxTreeLevel(maxTreeLevel);
            opts.setStrategy(SpatialSearchStrategy.QUAD_PREFIX_TREE);
            opts.setMinX(bounds.getMinX());
            opts.setMinY(bounds.getMinY());
            opts.setMaxX(bounds.getMaxX());
            opts.setMaxY(bounds.getMaxY());
            return opts;
        }
    }

    public static class GeographySpatialOptionsFactory {
        public SpatialOptions defaultOptions() {
            return this.defaultOptions(SpatialUnits.KILOMETERS);
        }

        public SpatialOptions defaultOptions(SpatialUnits circleRadiusUnits) {
            return this.geohashPrefixTreeIndex(0, circleRadiusUnits);
        }

        public SpatialOptions boundingBoxIndex() {
            return this.boundingBoxIndex(SpatialUnits.KILOMETERS);
        }

        public SpatialOptions boundingBoxIndex(SpatialUnits circleRadiusUnits) {
            SpatialOptions ops = new SpatialOptions();
            ops.setType(SpatialFieldType.GEOGRAPHY);
            ops.setStrategy(SpatialSearchStrategy.BOUNDING_BOX);
            ops.setUnits(circleRadiusUnits);
            return ops;
        }

        public SpatialOptions geohashPrefixTreeIndex(int maxTreeLevel) {
            return this.geohashPrefixTreeIndex(maxTreeLevel, SpatialUnits.KILOMETERS);
        }

        public SpatialOptions geohashPrefixTreeIndex(int maxTreeLevel, SpatialUnits circleRadiusUnits) {
            if (maxTreeLevel == 0) {
                maxTreeLevel = 9;
            }
            SpatialOptions opts = new SpatialOptions();
            opts.setType(SpatialFieldType.GEOGRAPHY);
            opts.setMaxTreeLevel(maxTreeLevel);
            opts.setStrategy(SpatialSearchStrategy.GEOHASH_PREFIX_TREE);
            opts.setUnits(circleRadiusUnits);
            return opts;
        }

        public SpatialOptions quadPrefixTreeIndex(int maxTreeLevel) {
            return this.quadPrefixTreeIndex(maxTreeLevel, SpatialUnits.KILOMETERS);
        }

        public SpatialOptions quadPrefixTreeIndex(int maxTreeLevel, SpatialUnits circleRadiusUnits) {
            if (maxTreeLevel == 0) {
                maxTreeLevel = 23;
            }
            SpatialOptions opts = new SpatialOptions();
            opts.setType(SpatialFieldType.GEOGRAPHY);
            opts.setMaxTreeLevel(maxTreeLevel);
            opts.setStrategy(SpatialSearchStrategy.QUAD_PREFIX_TREE);
            opts.setUnits(circleRadiusUnits);
            return opts;
        }
    }
}

