/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Defaults;
import java.io.IOException;
import net.ravendb.client.extensions.JsonExtensions;

public class CmpXchgResult<T> {
    private T value;
    private long index;
    private boolean successful;

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public static <T> CmpXchgResult<T> parseFromString(Class<T> clazz, String stringResponse) throws IOException {
        Object result;
        JsonNode response = JsonExtensions.getDefaultEntityMapper().readTree(stringResponse);
        if (!response.has("Index")) {
            throw new IllegalStateException("Response is invalid");
        }
        int index = response.get("Index").asInt();
        boolean successful = response.get("Successful").asBoolean();
        ObjectNode raw = (ObjectNode)response.get("Value");
        JsonNode val = null;
        if (raw != null) {
            val = raw.get("Object");
        }
        if (val == null) {
            CmpXchgResult<Object> xchgResult = new CmpXchgResult<Object>();
            xchgResult.setIndex(index);
            xchgResult.setValue(Defaults.defaultValue(clazz));
            xchgResult.setSuccessful(successful);
            return xchgResult;
        }
        try {
            result = val instanceof ObjectNode ? JsonExtensions.getDefaultEntityMapper().treeToValue((TreeNode)((ObjectNode)val), clazz) : JsonExtensions.getDefaultEntityMapper().treeToValue((TreeNode)raw.get("Object"), clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to parse json: " + e.getMessage(), e);
        }
        CmpXchgResult<Object> xchgResult = new CmpXchgResult<Object>();
        xchgResult.setIndex(index);
        xchgResult.setValue(result);
        xchgResult.setSuccessful(successful);
        return xchgResult;
    }
}

