/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Serializable;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.IOperation;
import net.ravendb.client.documents.operations.OperationIdResult;
import net.ravendb.client.documents.queries.IndexQuery;
import net.ravendb.client.documents.queries.QueryOperationOptions;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.HttpCache;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.HttpDeleteWithEntity;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.util.TimeUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class DeleteByQueryOperation
implements IOperation<OperationIdResult> {
    protected IndexQuery _queryToDelete;
    private final QueryOperationOptions _options;

    public DeleteByQueryOperation(IndexQuery queryToDelete) {
        this(queryToDelete, null);
    }

    public DeleteByQueryOperation(IndexQuery queryToDelete, QueryOperationOptions options) {
        if (queryToDelete == null) {
            throw new IllegalArgumentException("QueryToDelete cannot be null");
        }
        this._queryToDelete = queryToDelete;
        this._options = options;
    }

    @Override
    public RavenCommand<OperationIdResult> getCommand(IDocumentStore store, DocumentConventions conventions, HttpCache cache) {
        return new DeleteByIndexCommand(conventions, this._queryToDelete, this._options);
    }

    private static class DeleteByIndexCommand
    extends RavenCommand<OperationIdResult> {
        private final DocumentConventions _conventions;
        private final IndexQuery _queryToDelete;
        private final QueryOperationOptions _options;

        public DeleteByIndexCommand(DocumentConventions conventions, IndexQuery queryToDelete, QueryOperationOptions options) {
            super(OperationIdResult.class);
            this._conventions = conventions;
            this._queryToDelete = queryToDelete;
            this._options = (QueryOperationOptions)ObjectUtils.firstNonNull((Object[])new QueryOperationOptions[]{options, new QueryOperationOptions()});
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            StringBuilder path = new StringBuilder(node.getUrl()).append("/databases/").append(node.getDatabase()).append("/queries").append("?allowStale=").append(ObjectUtils.firstNonNull((Object[])new Serializable[]{Boolean.valueOf(this._options.isAllowStale()), ""}));
            if (this._options.getMaxOpsPerSecond() != null) {
                path.append("&maxOpsPerSec=").append(this._options.getMaxOpsPerSecond());
            }
            path.append("&details=").append(ObjectUtils.firstNonNull((Object[])new Serializable[]{Boolean.valueOf(this._options.isRetrieveDetails()), ""}));
            if (this._options.getStaleTimeout() != null) {
                path.append("&staleTimeout=").append(TimeUtils.durationToTimeSpan(this._options.getStaleTimeout()));
            }
            HttpDeleteWithEntity request = new HttpDeleteWithEntity();
            request.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
                try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                    JsonExtensions.writeIndexQuery(generator, this._conventions, this._queryToDelete);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, ContentType.APPLICATION_JSON));
            url.value = path.toString();
            return request;
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                DeleteByIndexCommand.throwInvalidResponse();
            }
            this.result = this.mapper.readValue(response, OperationIdResult.class);
        }

        @Override
        public boolean isReadRequest() {
            return false;
        }
    }
}

