/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.IOperation;
import net.ravendb.client.http.HttpCache;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class ListCompareExchangeValuesOperation
implements IOperation<List<CompareExchangeItem>> {
    private final String _keyPrefix;
    private final Integer _page;
    private final Integer _size;

    public ListCompareExchangeValuesOperation(String keyPrefix) {
        this(keyPrefix, null, null);
    }

    public ListCompareExchangeValuesOperation(String keyPrefix, Integer page) {
        this(keyPrefix, page, null);
    }

    public ListCompareExchangeValuesOperation(String keyPrefix, Integer page, Integer size) {
        this._keyPrefix = keyPrefix;
        this._page = page;
        this._size = size;
    }

    @Override
    public RavenCommand<List<CompareExchangeItem>> getCommand(IDocumentStore store, DocumentConventions conventions, HttpCache cache) {
        return new ListCompareExchangeValuesCommand(this._keyPrefix, this._page, this._size);
    }

    private static class ListCompareExchangeValuesCommand
    extends RavenCommand<List<CompareExchangeItem>> {
        private final String _keyPrefix;
        private final Integer _page;
        private final Integer _size;

        public ListCompareExchangeValuesCommand(String keyPrefix, Integer page, Integer size) {
            super(List.class);
            this._keyPrefix = keyPrefix;
            this._page = page;
            this._size = size;
        }

        @Override
        public boolean isReadRequest() {
            return true;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/cmpxchg/list?startsWith=" + this._keyPrefix;
            if (this._page != null) {
                url.value = url.value + "&start=" + this._page;
            }
            if (this._size != null) {
                url.value = url.value + "&pageSize=" + this._size;
            }
            return new HttpGet();
        }

        private List<CompareExchangeItem> getResult(ArrayNode array) {
            if (array == null) {
                return Collections.emptyList();
            }
            ArrayList<CompareExchangeItem> results = new ArrayList<CompareExchangeItem>();
            for (JsonNode jsonNode : array) {
                ObjectNode item = (ObjectNode)jsonNode;
                if (item == null || item.isNull()) continue;
                long index = item.get("Index").asLong();
                JsonNode raw = item.get("Value");
                String key = item.get("Key").asText();
                JsonNode val = null;
                if (raw != null && raw.has("Object")) {
                    val = raw.get("Object");
                }
                results.add(new CompareExchangeItem(key, index, val));
            }
            return results;
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            JsonNode jsonNode = this.mapper.readTree(response);
            JsonNode results = jsonNode.get("Results");
            this.result = this.getResult((ArrayNode)results);
        }
    }

    public static class CompareExchangeItem {
        private final String key;
        private final long index;
        private final JsonNode value;

        public CompareExchangeItem(String key, long index, JsonNode value) {
            this.key = key;
            this.index = index;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public long getIndex() {
            return this.index;
        }

        public JsonNode getValue() {
            return this.value;
        }
    }
}

