/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ravendb.client.documents.commands.GetOperationStateOperation;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.OperationExceptionResult;
import net.ravendb.client.exceptions.ExceptionDispatcher;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.RequestExecutor;
import net.ravendb.client.primitives.OperationCancelledException;

public class Operation {
    private final RequestExecutor _requestExecutor;
    private final DocumentConventions _conventions;
    private final long _id;

    public long getId() {
        return this._id;
    }

    public Operation(RequestExecutor requestExecutor, DocumentConventions conventions, long id) {
        this._requestExecutor = requestExecutor;
        this._conventions = conventions;
        this._id = id;
    }

    private ObjectNode fetchOperationsStatus() {
        RavenCommand<ObjectNode> command = this.getOperationStateCommand(this._conventions, this._id);
        this._requestExecutor.execute(command);
        return command.getResult();
    }

    protected RavenCommand<ObjectNode> getOperationStateCommand(DocumentConventions conventions, long id) {
        return new GetOperationStateOperation.GetOperationStateCommand(this._conventions, this._id);
    }

    public void waitForCompletion() {
        while (true) {
            String operationStatus;
            ObjectNode status = this.fetchOperationsStatus();
            switch (operationStatus = status.get("Status").asText()) {
                case "Completed": {
                    return;
                }
                case "Cancelled": {
                    throw new OperationCancelledException();
                }
                case "Faulted": {
                    JsonNode result = status.get("Result");
                    OperationExceptionResult exceptionResult = (OperationExceptionResult)JsonExtensions.getDefaultMapper().convertValue((Object)result, OperationExceptionResult.class);
                    throw ExceptionDispatcher.get(exceptionResult.getMessage(), exceptionResult.getError(), exceptionResult.getType(), exceptionResult.getStatusCode());
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

