/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.IOperation;
import net.ravendb.client.documents.operations.OperationIdResult;
import net.ravendb.client.documents.queries.IndexQuery;
import net.ravendb.client.documents.queries.QueryOperationOptions;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.HttpCache;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.util.TimeUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class PatchByQueryOperation
implements IOperation<OperationIdResult> {
    protected static IndexQuery DUMMY_QUERY = new IndexQuery();
    private final IndexQuery _queryToUpdate;
    private final QueryOperationOptions _options;

    public PatchByQueryOperation(String queryToUpdate) {
        this(new IndexQuery(queryToUpdate));
    }

    public PatchByQueryOperation(IndexQuery queryToUpdate) {
        this(queryToUpdate, null);
    }

    public PatchByQueryOperation(IndexQuery queryToUpdate, QueryOperationOptions options) {
        if (queryToUpdate == null) {
            throw new IllegalArgumentException("QueryToUpdate cannot be null");
        }
        this._queryToUpdate = queryToUpdate;
        this._options = options;
    }

    @Override
    public RavenCommand<OperationIdResult> getCommand(IDocumentStore store, DocumentConventions conventions, HttpCache cache) {
        return new PatchByIndexCommand(conventions, this._queryToUpdate, this._options);
    }

    private static class PatchByIndexCommand
    extends RavenCommand<OperationIdResult> {
        private final DocumentConventions _conventions;
        private final IndexQuery _queryToUpdate;
        private final QueryOperationOptions _options;

        public PatchByIndexCommand(DocumentConventions conventions, IndexQuery queryToUpdate, QueryOperationOptions options) {
            super(OperationIdResult.class);
            this._conventions = conventions;
            this._queryToUpdate = queryToUpdate;
            this._options = (QueryOperationOptions)ObjectUtils.firstNonNull((Object[])new QueryOperationOptions[]{options, new QueryOperationOptions()});
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            String path = node.getUrl() + "/databases/" + node.getDatabase() + "/queries?allowStale=" + this._options.isAllowStale();
            if (this._options.getMaxOpsPerSecond() != null) {
                path = path + "&maxOpsPerSec=" + this._options.getMaxOpsPerSecond();
            }
            path = path + "&details=" + this._options.isRetrieveDetails();
            if (this._options.getStaleTimeout() != null) {
                path = path + "&staleTimeout=" + TimeUtils.durationToTimeSpan(this._options.getStaleTimeout());
            }
            HttpPatch request = new HttpPatch();
            request.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
                try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                    generator.writeStartObject();
                    generator.writeFieldName("Query");
                    JsonExtensions.writeIndexQuery(generator, this._conventions, this._queryToUpdate);
                    generator.writeEndObject();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, ContentType.APPLICATION_JSON));
            url.value = path;
            return request;
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                PatchByIndexCommand.throwInvalidResponse();
            }
            this.result = this.mapper.readValue(response, OperationIdResult.class);
        }

        @Override
        public boolean isReadRequest() {
            return false;
        }
    }
}

