/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.CmpXchgResult;
import net.ravendb.client.documents.operations.IOperation;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.HttpCache;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.Reference;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class PutCompareExchangeValueOperation<T>
implements IOperation<CmpXchgResult<T>> {
    private final String _key;
    private final T _value;
    private final long _index;

    public PutCompareExchangeValueOperation(String key, T value, long index) {
        this._key = key;
        this._value = value;
        this._index = index;
    }

    @Override
    public RavenCommand<CmpXchgResult<T>> getCommand(IDocumentStore store, DocumentConventions conventions, HttpCache cache) {
        return new PutCompareExchangeValueCommand<T>(this._key, this._value, this._index, conventions);
    }

    private static class PutCompareExchangeValueCommand<T>
    extends RavenCommand<CmpXchgResult<T>> {
        private final String _key;
        private final T _value;
        private final long _index;
        private final DocumentConventions _conventions;

        public PutCompareExchangeValueCommand(String key, T value, long index, DocumentConventions conventions) {
            super(CmpXchgResult.class);
            if (StringUtils.isEmpty((CharSequence)key)) {
                throw new IllegalArgumentException("The key argument must have value");
            }
            if (index < 0L) {
                throw new IllegalStateException("Index must be a non-negative number");
            }
            this._key = key;
            this._value = value;
            this._index = index;
            this._conventions = (DocumentConventions)ObjectUtils.firstNonNull((Object[])new DocumentConventions[]{conventions, DocumentConventions.defaultConventions});
        }

        @Override
        public boolean isReadRequest() {
            return false;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/cmpxchg?key=" + this._key + "&index=" + this._index;
            HashMap<String, T> tuple = new HashMap<String, T>();
            tuple.put("Object", this._value);
            ObjectNode json = (ObjectNode)JsonExtensions.getDefaultEntityMapper().valueToTree(tuple);
            HttpPut httpPut = new HttpPut();
            httpPut.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
                try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                    generator.writeTree((TreeNode)json);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, ContentType.APPLICATION_JSON));
            return httpPut;
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            this.result = CmpXchgResult.parseFromString(this._value.getClass(), response);
        }
    }
}

