/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations.configuration;

import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.IMaintenanceOperation;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.serverwide.ClientConfiguration;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class GetClientConfigurationOperation
implements IMaintenanceOperation<Result> {
    @Override
    public RavenCommand<Result> getCommand(DocumentConventions conventions) {
        return new GetClientConfigurationCommand();
    }

    public static class Result {
        private long etag;
        private ClientConfiguration configuration;

        public long getEtag() {
            return this.etag;
        }

        public void setEtag(long etag) {
            this.etag = etag;
        }

        public ClientConfiguration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(ClientConfiguration configuration) {
            this.configuration = configuration;
        }
    }

    public static class GetClientConfigurationCommand
    extends RavenCommand<Result> {
        public GetClientConfigurationCommand() {
            super(Result.class);
        }

        @Override
        public boolean isReadRequest() {
            return false;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/configuration/client";
            return new HttpGet();
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                return;
            }
            this.result = this.mapper.readValue(response, this.resultClass);
        }
    }
}

