/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.queries;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.ravendb.client.Parameters;
import org.apache.commons.codec.digest.DigestUtils;

public class QueryHashCalculator {
    private final ByteArrayOutputStream _buffer = new ByteArrayOutputStream();

    public String getHash() {
        return DigestUtils.md5Hex((byte[])this._buffer.toByteArray());
    }

    public void write(float f) throws IOException {
        this._buffer.write(ByteBuffer.allocate(4).putFloat(f).array());
    }

    public void write(long l) throws IOException {
        this._buffer.write(ByteBuffer.allocate(8).putLong(l).array());
    }

    public void write(Long l) throws IOException {
        if (l == null) {
            return;
        }
        this.write((long)l);
    }

    public void write(Float f) throws IOException {
        if (f == null) {
            return;
        }
        this.write(f.floatValue());
    }

    public void write(Integer i) throws IOException {
        if (i == null) {
            return;
        }
        this.write((int)i);
    }

    public void write(int i) throws IOException {
        this._buffer.write(ByteBuffer.allocate(4).putInt(i).array());
    }

    public void write(Boolean b) {
        if (b == null) {
            return;
        }
        this.write((boolean)b);
    }

    public void write(boolean b) {
        this._buffer.write(b ? 1 : 2);
    }

    public void write(String s) throws IOException {
        if (s == null) {
            return;
        }
        this._buffer.write(s.getBytes());
    }

    public void write(String[] s) throws IOException {
        if (s == null) {
            return;
        }
        for (String value : s) {
            this.write(value);
        }
    }

    public void write(List<String> s) throws IOException {
        if (s == null) {
            return;
        }
        for (String value : s) {
            this.write(value);
        }
    }

    public void write(Parameters qp) throws IOException {
        if (qp == null) {
            return;
        }
        for (Map.Entry kvp : qp.entrySet()) {
            this.write((String)kvp.getKey());
            this.writeParameterValue(kvp.getValue());
        }
    }

    private void writeParameterValue(Object value) throws IOException {
        if (value instanceof String) {
            this.write((String)value);
        } else if (value instanceof Long) {
            this.write((Long)value);
        } else if (value instanceof Integer) {
            this.write((Integer)value);
        } else if (value instanceof Boolean) {
            this.write((Boolean)value);
        } else if (value != null) {
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    this.writeParameterValue(o);
                }
            } else {
                this.write(value.toString());
            }
        }
    }

    public void write(Map<String, String> qp) throws IOException {
        if (qp == null) {
            return;
        }
        for (Map.Entry<String, String> kvp : qp.entrySet()) {
            this.write(kvp.getKey());
            this.write(kvp.getValue());
        }
    }
}

