/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.queries.spatial;

import net.ravendb.client.documents.indexes.spatial.SpatialRelation;
import net.ravendb.client.documents.indexes.spatial.SpatialUnits;
import net.ravendb.client.documents.queries.spatial.CircleCriteria;
import net.ravendb.client.documents.queries.spatial.SpatialCriteria;
import net.ravendb.client.documents.queries.spatial.WktCriteria;

public class SpatialCriteriaFactory {
    public static final SpatialCriteriaFactory INSTANCE = new SpatialCriteriaFactory();

    private SpatialCriteriaFactory() {
    }

    public SpatialCriteria relatesToShape(String shapeWkt, SpatialRelation relation) {
        return this.relatesToShape(shapeWkt, relation, 0.025);
    }

    public SpatialCriteria relatesToShape(String shapeWkt, SpatialRelation relation, double distErrorPercent) {
        return new WktCriteria(shapeWkt, relation, distErrorPercent);
    }

    public SpatialCriteria intersects(String shapeWkt) {
        return this.intersects(shapeWkt, 0.025);
    }

    public SpatialCriteria intersects(String shapeWkt, double distErrorPercent) {
        return this.relatesToShape(shapeWkt, SpatialRelation.INTERSECTS, distErrorPercent);
    }

    public SpatialCriteria contains(String shapeWkt) {
        return this.contains(shapeWkt, 0.025);
    }

    public SpatialCriteria contains(String shapeWkt, double distErrorPercent) {
        return this.relatesToShape(shapeWkt, SpatialRelation.CONTAINS, distErrorPercent);
    }

    public SpatialCriteria disjoint(String shapeWkt) {
        return this.disjoint(shapeWkt, 0.025);
    }

    public SpatialCriteria disjoint(String shapeWkt, double distErrorPercent) {
        return this.relatesToShape(shapeWkt, SpatialRelation.DISJOINT, distErrorPercent);
    }

    public SpatialCriteria within(String shapeWkt) {
        return this.within(shapeWkt, 0.025);
    }

    public SpatialCriteria within(String shapeWkt, double distErrorPercent) {
        return this.relatesToShape(shapeWkt, SpatialRelation.WITHIN, distErrorPercent);
    }

    public SpatialCriteria withinRadius(double radius, double latitude, double longitude) {
        return this.withinRadius(radius, latitude, longitude, null);
    }

    public SpatialCriteria withinRadius(double radius, double latitude, double longitude, SpatialUnits radiusUnits) {
        return this.withinRadius(radius, latitude, longitude, radiusUnits, 0.025);
    }

    public SpatialCriteria withinRadius(double radius, double latitude, double longitude, SpatialUnits radiusUnits, double distErrorPercent) {
        return new CircleCriteria(radius, latitude, longitude, radiusUnits, SpatialRelation.WITHIN, distErrorPercent);
    }
}

