/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session;

import com.google.common.collect.Sets;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.ravendb.client.documents.indexes.spatial.SpatialRelation;
import net.ravendb.client.documents.indexes.spatial.SpatialUnits;
import net.ravendb.client.documents.queries.GroupBy;
import net.ravendb.client.documents.queries.IndexQuery;
import net.ravendb.client.documents.queries.QueryData;
import net.ravendb.client.documents.queries.QueryOperator;
import net.ravendb.client.documents.queries.QueryResult;
import net.ravendb.client.documents.queries.SearchOperator;
import net.ravendb.client.documents.queries.spatial.DynamicSpatialField;
import net.ravendb.client.documents.queries.spatial.SpatialCriteria;
import net.ravendb.client.documents.queries.spatial.SpatialCriteriaFactory;
import net.ravendb.client.documents.session.AbstractDocumentQuery;
import net.ravendb.client.documents.session.GroupByDocumentQuery;
import net.ravendb.client.documents.session.IDocumentQuery;
import net.ravendb.client.documents.session.IGroupByDocumentQuery;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;
import net.ravendb.client.documents.session.MethodCall;
import net.ravendb.client.documents.session.OrderingType;
import net.ravendb.client.documents.session.QueryStatistics;
import net.ravendb.client.documents.session.WhereParams;
import net.ravendb.client.documents.session.tokens.DeclareToken;
import net.ravendb.client.documents.session.tokens.FieldsToFetchToken;
import net.ravendb.client.documents.session.tokens.LoadToken;
import net.ravendb.client.primitives.Reference;

public class DocumentQuery<T>
extends AbstractDocumentQuery<T, DocumentQuery<T>>
implements IDocumentQuery<T> {
    public DocumentQuery(Class<T> clazz, InMemoryDocumentSessionOperations session, String indexName, String collectionName, boolean isGroupBy) {
        this(clazz, session, indexName, collectionName, isGroupBy, null, null, null);
    }

    public DocumentQuery(Class<T> clazz, InMemoryDocumentSessionOperations session, String indexName, String collectionName, boolean isGroupBy, DeclareToken declareToken, List<LoadToken> loadTokens, String fromAlias) {
        super(clazz, session, indexName, collectionName, isGroupBy, declareToken, loadTokens, fromAlias);
    }

    @Override
    public <TProjection> IDocumentQuery<TProjection> selectFields(Class<TProjection> projectionClass) {
        try {
            Field identityProperty = this.getConventions().getIdentityProperty(projectionClass);
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(projectionClass).getPropertyDescriptors();
            String[] projections = (String[])Arrays.stream(propertyDescriptors).map(x -> x.getName()).toArray(String[]::new);
            String[] fields = (String[])Arrays.stream(propertyDescriptors).map(p -> p.getName().equals(identityProperty.getName()) ? "id()" : p.getName()).toArray(String[]::new);
            return this.selectFields(projectionClass, new QueryData(fields, projections));
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Unable to project to class: " + projectionClass.getName() + e.getMessage(), e);
        }
    }

    @Override
    public IDocumentQuery<T> distinct() {
        this._distinct();
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByScore() {
        this._orderByScore();
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByScoreDescending() {
        this._orderByScoreDescending();
        return this;
    }

    @Override
    public <TProjection> IDocumentQuery<TProjection> selectFields(Class<TProjection> projectionClass, String ... fields) {
        QueryData queryData = new QueryData(fields, fields);
        return this.selectFields(projectionClass, queryData);
    }

    @Override
    public <TProjection> IDocumentQuery<TProjection> selectFields(Class<TProjection> projectionClass, QueryData queryData) {
        return this.createDocumentQueryInternal(projectionClass, queryData);
    }

    @Override
    public IDocumentQuery<T> waitForNonStaleResults() {
        this._waitForNonStaleResults(null);
        return this;
    }

    @Override
    public IDocumentQuery<T> waitForNonStaleResults(Duration waitTimeout) {
        this._waitForNonStaleResults(waitTimeout);
        return this;
    }

    @Override
    public IDocumentQuery<T> addParameter(String name, Object value) {
        this._addParameter(name, value);
        return this;
    }

    @Override
    public IDocumentQuery<T> addOrder(String fieldName, boolean descending) {
        return this.addOrder(fieldName, descending, OrderingType.STRING);
    }

    @Override
    public IDocumentQuery<T> addOrder(String fieldName, boolean descending, OrderingType ordering) {
        if (descending) {
            this.orderByDescending(fieldName, ordering);
        } else {
            this.orderBy(fieldName, ordering);
        }
        return this;
    }

    @Override
    public IDocumentQuery<T> addAfterQueryExecutedListener(Consumer<QueryResult> action) {
        this._addAfterQueryExecutedListener(action);
        return this;
    }

    @Override
    public IDocumentQuery<T> removeAfterQueryExecutedListener(Consumer<QueryResult> action) {
        this._removeAfterQueryExecutedListener(action);
        return this;
    }

    @Override
    public IDocumentQuery<T> openSubclause() {
        this._openSubclause();
        return this;
    }

    @Override
    public IDocumentQuery<T> closeSubclause() {
        this._closeSubclause();
        return this;
    }

    @Override
    public IDocumentQuery<T> search(String fieldName, String searchTerms) {
        this._search(fieldName, searchTerms);
        return this;
    }

    @Override
    public IDocumentQuery<T> search(String fieldName, String searchTerms, SearchOperator operator) {
        this._search(fieldName, searchTerms, operator);
        return this;
    }

    @Override
    public IDocumentQuery<T> intersect() {
        this._intersect();
        return this;
    }

    @Override
    public IDocumentQuery<T> containsAny(String fieldName, Collection<Object> values) {
        this._containsAny(fieldName, values);
        return this;
    }

    @Override
    public IDocumentQuery<T> containsAll(String fieldName, Collection<Object> values) {
        this._containsAll(fieldName, values);
        return this;
    }

    @Override
    public IDocumentQuery<T> statistics(Reference<QueryStatistics> stats) {
        this._statistics(stats);
        return this;
    }

    @Override
    public IDocumentQuery<T> usingDefaultOperator(QueryOperator queryOperator) {
        this._usingDefaultOperator(queryOperator);
        return this;
    }

    @Override
    public IDocumentQuery<T> noTracking() {
        this._noTracking();
        return this;
    }

    @Override
    public IDocumentQuery<T> noCaching() {
        this._noCaching();
        return this;
    }

    @Override
    public IDocumentQuery<T> include(String path) {
        this._include(path);
        return this;
    }

    @Override
    public IDocumentQuery<T> not() {
        this.negateNext();
        return this;
    }

    @Override
    public IDocumentQuery<T> take(int count) {
        this._take(count);
        return this;
    }

    @Override
    public IDocumentQuery<T> skip(int count) {
        this._skip(count);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereLucene(String fieldName, String whereClause) {
        this._whereLucene(fieldName, whereClause);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereEquals(String fieldName, Object value) {
        this._whereEquals(fieldName, value, false);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereEquals(String fieldName, Object value, boolean exact) {
        this._whereEquals(fieldName, value, exact);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereEquals(String fieldName, MethodCall method) {
        this._whereEquals(fieldName, method);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereEquals(String fieldName, MethodCall method, boolean exact) {
        this._whereEquals(fieldName, method, exact);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereEquals(WhereParams whereParams) {
        this._whereEquals(whereParams);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereNotEquals(String fieldName, Object value) {
        this._whereNotEquals(fieldName, value);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereNotEquals(String fieldName, Object value, boolean exact) {
        this._whereNotEquals(fieldName, value, exact);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereNotEquals(String fieldName, MethodCall method) {
        this._whereNotEquals(fieldName, method);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereNotEquals(String fieldName, MethodCall method, boolean exact) {
        this._whereNotEquals(fieldName, method, exact);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereNotEquals(WhereParams whereParams) {
        this._whereNotEquals(whereParams);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereIn(String fieldName, Collection<Object> values) {
        return this.whereIn(fieldName, (Collection)values, false);
    }

    @Override
    public IDocumentQuery<T> whereIn(String fieldName, Collection<Object> values, boolean exact) {
        this._whereIn(fieldName, values, exact);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereStartsWith(String fieldName, Object value) {
        this._whereStartsWith(fieldName, value);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereEndsWith(String fieldName, Object value) {
        this._whereEndsWith(fieldName, value);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereBetween(String fieldName, Object start, Object end) {
        return this.whereBetween(fieldName, start, end, false);
    }

    @Override
    public IDocumentQuery<T> whereBetween(String fieldName, Object start, Object end, boolean exact) {
        this._whereBetween(fieldName, start, end, exact);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereGreaterThan(String fieldName, Object value) {
        return this.whereGreaterThan(fieldName, value, false);
    }

    @Override
    public IDocumentQuery<T> whereGreaterThan(String fieldName, Object value, boolean exact) {
        this._whereGreaterThan(fieldName, value, exact);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereGreaterThanOrEqual(String fieldName, Object value) {
        return this.whereGreaterThanOrEqual(fieldName, value, false);
    }

    @Override
    public IDocumentQuery<T> whereGreaterThanOrEqual(String fieldName, Object value, boolean exact) {
        this._whereGreaterThanOrEqual(fieldName, value, exact);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereLessThan(String fieldName, Object value) {
        return this.whereLessThan(fieldName, value, false);
    }

    @Override
    public IDocumentQuery<T> whereLessThan(String fieldName, Object value, boolean exact) {
        this._whereLessThan(fieldName, value, exact);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereLessThanOrEqual(String fieldName, Object value) {
        return this.whereLessThanOrEqual(fieldName, value, false);
    }

    @Override
    public IDocumentQuery<T> whereLessThanOrEqual(String fieldName, Object value, boolean exact) {
        this._whereLessThanOrEqual(fieldName, value, exact);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereExists(String fieldName) {
        this._whereExists(fieldName);
        return this;
    }

    @Override
    public IDocumentQuery<T> whereRegex(String fieldName, String pattern) {
        this._whereRegex(fieldName, pattern);
        return this;
    }

    @Override
    public IDocumentQuery<T> andAlso() {
        this._andAlso();
        return this;
    }

    @Override
    public IDocumentQuery<T> orElse() {
        this._orElse();
        return this;
    }

    @Override
    public IDocumentQuery<T> boost(double boost) {
        this._boost(boost);
        return this;
    }

    @Override
    public IDocumentQuery<T> fuzzy(double fuzzy) {
        this._fuzzy(fuzzy);
        return this;
    }

    @Override
    public IDocumentQuery<T> proximity(int proximity) {
        this._proximity(proximity);
        return this;
    }

    @Override
    public IDocumentQuery<T> randomOrdering() {
        this._randomOrdering();
        return this;
    }

    @Override
    public IDocumentQuery<T> randomOrdering(String seed) {
        this._randomOrdering(seed);
        return this;
    }

    @Override
    public IGroupByDocumentQuery<T> groupBy(String fieldName, String ... fieldNames) {
        this._groupBy(fieldName, fieldNames);
        return new GroupByDocumentQuery(this);
    }

    @Override
    public IGroupByDocumentQuery<T> groupBy(GroupBy field, GroupBy ... fields) {
        this._groupBy(field, fields);
        return new GroupByDocumentQuery(this);
    }

    @Override
    public <TResult> IDocumentQuery<TResult> ofType(Class<TResult> tResultClass) {
        return this.createDocumentQueryInternal(tResultClass);
    }

    @Override
    public IDocumentQuery<T> orderBy(String field) {
        return this.orderBy(field, OrderingType.STRING);
    }

    @Override
    public IDocumentQuery<T> orderBy(String field, OrderingType ordering) {
        this._orderBy(field, ordering);
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByDescending(String field) {
        return this.orderByDescending(field, OrderingType.STRING);
    }

    @Override
    public IDocumentQuery<T> orderByDescending(String field, OrderingType ordering) {
        this._orderByDescending(field, ordering);
        return this;
    }

    @Override
    public IDocumentQuery<T> addBeforeQueryExecutedListener(Consumer<IndexQuery> action) {
        this._addBeforeQueryExecutedListener(action);
        return this;
    }

    @Override
    public IDocumentQuery<T> removeBeforeQueryExecutedListener(Consumer<IndexQuery> action) {
        this._removeBeforeQueryExecutedListener(action);
        return this;
    }

    private <TResult> DocumentQuery<TResult> createDocumentQueryInternal(Class<TResult> resultClass) {
        return this.createDocumentQueryInternal(resultClass, null);
    }

    private <TResult> DocumentQuery<TResult> createDocumentQueryInternal(Class<TResult> resultClass, QueryData queryData) {
        FieldsToFetchToken newFieldsToFetch;
        FieldsToFetchToken fieldsToFetchToken = newFieldsToFetch = queryData != null && queryData.getFields().length > 0 ? FieldsToFetchToken.create(queryData.getFields(), queryData.getProjections(), queryData.isCustomFunction()) : null;
        if (newFieldsToFetch != null) {
            this.updateFieldsToFetchToken(newFieldsToFetch);
        }
        DocumentQuery<TResult> query = new DocumentQuery<TResult>(resultClass, this.theSession, this.getIndexName(), this.getCollectionName(), this.isGroupBy, queryData != null ? queryData.getDeclareToken() : null, queryData != null ? queryData.getLoadTokens() : null, queryData != null ? queryData.getFromAlias() : null);
        query.queryRaw = this.queryRaw;
        query.pageSize = this.pageSize;
        query.selectTokens = this.selectTokens;
        query.fieldsToFetchToken = this.fieldsToFetchToken;
        query.whereTokens = this.whereTokens;
        query.orderByTokens = this.orderByTokens;
        query.groupByTokens = this.groupByTokens;
        query.queryParameters = this.queryParameters;
        query.start = this.start;
        query.timeout = this.timeout;
        query.queryStats = this.queryStats;
        query.theWaitForNonStaleResults = this.theWaitForNonStaleResults;
        query.negate = this.negate;
        query.includes = new HashSet(this.includes);
        query.rootTypes = Sets.newHashSet((Object[])new Class[]{this.clazz});
        query.beforeQueryExecutedCallback = this.beforeQueryExecutedCallback;
        query.afterQueryExecutedCallback = this.afterQueryExecutedCallback;
        query.disableEntitiesTracking = this.disableEntitiesTracking;
        query.disableCaching = this.disableCaching;
        query.isIntersect = this.isIntersect;
        query.defaultOperator = this.defaultOperator;
        return query;
    }

    @Override
    public IDocumentQuery<T> spatial(String fieldName, Function<SpatialCriteriaFactory, SpatialCriteria> clause) {
        SpatialCriteria criteria = clause.apply(SpatialCriteriaFactory.INSTANCE);
        this._spatial(fieldName, criteria);
        return this;
    }

    @Override
    public IDocumentQuery<T> spatial(DynamicSpatialField field, Function<SpatialCriteriaFactory, SpatialCriteria> clause) {
        SpatialCriteria criteria = clause.apply(SpatialCriteriaFactory.INSTANCE);
        this._spatial(field, criteria);
        return this;
    }

    @Override
    public IDocumentQuery<T> withinRadiusOf(String fieldName, double radius, double latitude, double longitude) {
        return this.withinRadiusOf(fieldName, radius, latitude, longitude, null, 0.025);
    }

    @Override
    public IDocumentQuery<T> withinRadiusOf(String fieldName, double radius, double latitude, double longitude, SpatialUnits radiusUnits) {
        return this.withinRadiusOf(fieldName, radius, latitude, longitude, radiusUnits, 0.025);
    }

    @Override
    public IDocumentQuery<T> withinRadiusOf(String fieldName, double radius, double latitude, double longitude, SpatialUnits radiusUnits, double distanceErrorPct) {
        this._withinRadiusOf(fieldName, radius, latitude, longitude, radiusUnits, distanceErrorPct);
        return this;
    }

    @Override
    public IDocumentQuery<T> relatesToShape(String fieldName, String shapeWkt, SpatialRelation relation) {
        return this.relatesToShape(fieldName, shapeWkt, relation, 0.025);
    }

    @Override
    public IDocumentQuery<T> relatesToShape(String fieldName, String shapeWkt, SpatialRelation relation, double distanceErrorPct) {
        this._spatial(fieldName, shapeWkt, relation, distanceErrorPct);
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByDistance(DynamicSpatialField field, double latitude, double longitude) {
        this._orderByDistance(field, latitude, longitude);
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByDistance(DynamicSpatialField field, String shapeWkt) {
        this._orderByDistance(field, shapeWkt);
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByDistance(String fieldName, double latitude, double longitude) {
        this._orderByDistance(fieldName, latitude, longitude);
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByDistance(String fieldName, String shapeWkt) {
        this._orderByDistance(fieldName, shapeWkt);
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByDistanceDescending(DynamicSpatialField field, double latitude, double longitude) {
        this._orderByDistanceDescending(field, latitude, longitude);
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByDistanceDescending(DynamicSpatialField field, String shapeWkt) {
        this._orderByDistanceDescending(field, shapeWkt);
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByDistanceDescending(String fieldName, double latitude, double longitude) {
        this._orderByDistanceDescending(fieldName, latitude, longitude);
        return this;
    }

    @Override
    public IDocumentQuery<T> orderByDistanceDescending(String fieldName, String shapeWkt) {
        this._orderByDistanceDescending(fieldName, shapeWkt);
        return this;
    }
}

