/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session;

import com.google.common.base.Defaults;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.ravendb.client.documents.DocumentStore;
import net.ravendb.client.documents.commands.GetDocumentsCommand;
import net.ravendb.client.documents.commands.GetDocumentsResult;
import net.ravendb.client.documents.commands.HeadDocumentCommand;
import net.ravendb.client.documents.commands.batches.BatchCommand;
import net.ravendb.client.documents.indexes.AbstractIndexCreationTask;
import net.ravendb.client.documents.linq.IDocumentQueryGenerator;
import net.ravendb.client.documents.queries.Query;
import net.ravendb.client.documents.session.DocumentInfo;
import net.ravendb.client.documents.session.DocumentQuery;
import net.ravendb.client.documents.session.IAdvancedSessionOperations;
import net.ravendb.client.documents.session.IDocumentQuery;
import net.ravendb.client.documents.session.IDocumentSessionImpl;
import net.ravendb.client.documents.session.IRawDocumentQuery;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;
import net.ravendb.client.documents.session.RawDocumentQuery;
import net.ravendb.client.documents.session.loaders.ILoaderWithInclude;
import net.ravendb.client.documents.session.loaders.MultiLoaderWithInclude;
import net.ravendb.client.documents.session.operations.BatchOperation;
import net.ravendb.client.documents.session.operations.LoadOperation;
import net.ravendb.client.documents.session.operations.LoadStartingWithOperation;
import net.ravendb.client.http.RequestExecutor;
import net.ravendb.client.json.JsonArrayResult;
import net.ravendb.client.primitives.Tuple;
import org.apache.commons.lang3.StringUtils;

public class DocumentSession
extends InMemoryDocumentSessionOperations
implements IAdvancedSessionOperations,
IDocumentSessionImpl,
IDocumentQueryGenerator {
    @Override
    public IAdvancedSessionOperations advanced() {
        return this;
    }

    public DocumentSession(String dbName, DocumentStore documentStore, UUID id, RequestExecutor requestExecutor) {
        super(dbName, documentStore, requestExecutor, id);
    }

    @Override
    public void saveChanges() {
        BatchOperation saveChangeOperation = new BatchOperation(this);
        try (BatchCommand command = saveChangeOperation.createRequest();){
            if (command == null) {
                return;
            }
            this._requestExecutor.execute(command, this.sessionInfo);
            saveChangeOperation.setResult((JsonArrayResult)command.getResult());
        }
    }

    @Override
    public boolean exists(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (this.documentsById.getValue(id) != null) {
            return true;
        }
        HeadDocumentCommand command = new HeadDocumentCommand(id, null);
        this._requestExecutor.execute(command, this.sessionInfo);
        return command.getResult() != null;
    }

    @Override
    public <T> void refresh(T entity) {
        DocumentInfo documentInfo = (DocumentInfo)this.documentsByEntity.get(entity);
        if (documentInfo == null) {
            throw new IllegalStateException("Cannot refresh a transient instance");
        }
        this.incrementRequestCount();
        GetDocumentsCommand command = new GetDocumentsCommand(new String[]{documentInfo.getId()}, null, false);
        this._requestExecutor.execute(command, this.sessionInfo);
        this.refreshInternal(entity, command, documentInfo);
    }

    @Override
    protected String generateId(Object entity) {
        return this.getConventions().generateDocumentId(this.getDatabaseName(), entity);
    }

    @Override
    public ILoaderWithInclude include(String path) {
        return new MultiLoaderWithInclude(this).include(path);
    }

    @Override
    public <T> T load(Class<T> clazz, String id) {
        if (id == null) {
            return (T)Defaults.defaultValue(clazz);
        }
        LoadOperation loadOperation = new LoadOperation(this);
        loadOperation.byId(id);
        GetDocumentsCommand command = loadOperation.createRequest();
        if (command != null) {
            this._requestExecutor.execute(command, this.sessionInfo);
            loadOperation.setResult((GetDocumentsResult)command.getResult());
        }
        return loadOperation.getDocument(clazz);
    }

    public <T> Map<String, T> load(Class<T> clazz, String ... ids) {
        LoadOperation loadOperation = new LoadOperation(this);
        this.loadInternal(ids, loadOperation);
        return loadOperation.getDocuments(clazz);
    }

    public <T> Map<String, T> load(Class<T> clazz, Collection<String> ids) {
        LoadOperation loadOperation = new LoadOperation(this);
        this.loadInternal(ids.toArray(new String[0]), loadOperation);
        return loadOperation.getDocuments(clazz);
    }

    private <T> void loadInternal(String[] ids, LoadOperation operation) {
        operation.byIds(ids);
        GetDocumentsCommand command = operation.createRequest();
        if (command != null) {
            this._requestExecutor.execute(command, this.sessionInfo);
            operation.setResult((GetDocumentsResult)command.getResult());
        }
    }

    public <TResult> Map<String, TResult> loadInternal(Class<TResult> clazz, String[] ids, String[] includes) {
        LoadOperation loadOperation = new LoadOperation(this);
        loadOperation.byIds(ids);
        loadOperation.withIncludes(includes);
        GetDocumentsCommand command = loadOperation.createRequest();
        if (command != null) {
            this._requestExecutor.execute(command, this.sessionInfo);
            loadOperation.setResult((GetDocumentsResult)command.getResult());
        }
        return loadOperation.getDocuments(clazz);
    }

    @Override
    public <T> T[] loadStartingWith(Class<T> clazz, String idPrefix) {
        return this.loadStartingWith(clazz, idPrefix, null, 0, 25, null, null);
    }

    @Override
    public <T> T[] loadStartingWith(Class<T> clazz, String idPrefix, String matches) {
        return this.loadStartingWith(clazz, idPrefix, matches, 0, 25, null, null);
    }

    @Override
    public <T> T[] loadStartingWith(Class<T> clazz, String idPrefix, String matches, int start) {
        return this.loadStartingWith(clazz, idPrefix, matches, start, 25, null, null);
    }

    @Override
    public <T> T[] loadStartingWith(Class<T> clazz, String idPrefix, String matches, int start, int pageSize) {
        return this.loadStartingWith(clazz, idPrefix, matches, start, pageSize, null, null);
    }

    @Override
    public <T> T[] loadStartingWith(Class<T> clazz, String idPrefix, String matches, int start, int pageSize, String exclude) {
        return this.loadStartingWith(clazz, idPrefix, matches, start, pageSize, exclude, null);
    }

    @Override
    public <T> T[] loadStartingWith(Class<T> clazz, String idPrefix, String matches, int start, int pageSize, String exclude, String startAfter) {
        LoadStartingWithOperation loadStartingWithOperation = new LoadStartingWithOperation(this);
        this.loadStartingWithInternal(idPrefix, loadStartingWithOperation, matches, start, pageSize, exclude, startAfter);
        return loadStartingWithOperation.getDocuments(clazz);
    }

    private GetDocumentsCommand loadStartingWithInternal(String idPrefix, LoadStartingWithOperation operation, String matches, int start, int pageSize, String exclude, String startAfter) {
        operation.withStartWith(idPrefix, matches, start, pageSize, exclude, startAfter);
        GetDocumentsCommand command = operation.createRequest();
        if (command != null) {
            this._requestExecutor.execute(command, this.sessionInfo);
            operation.setResult((GetDocumentsResult)command.getResult());
        }
        return command;
    }

    @Override
    public <T, TIndex extends AbstractIndexCreationTask> IDocumentQuery<T> documentQuery(Class<T> clazz, Class<TIndex> indexClazz) {
        try {
            AbstractIndexCreationTask index = (AbstractIndexCreationTask)indexClazz.newInstance();
            return this.documentQuery(clazz, index.getIndexName(), null, index.isMapReduce());
        }
        catch (IllegalAccessException | IllegalStateException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> IDocumentQuery<T> documentQuery(Class<T> clazz) {
        return this.documentQuery(clazz, null, null, false);
    }

    @Override
    public <T> IDocumentQuery<T> documentQuery(Class<T> clazz, String indexName, String collectionName, boolean isMapReduce) {
        Tuple<String, String> indexNameAndCollection = this.processQueryParameters(clazz, indexName, collectionName, this.getConventions());
        indexName = (String)indexNameAndCollection.first;
        collectionName = (String)indexNameAndCollection.second;
        return new DocumentQuery<T>(clazz, this, indexName, collectionName, isMapReduce);
    }

    @Override
    public <T> IRawDocumentQuery<T> rawQuery(Class<T> clazz, String query) {
        return new RawDocumentQuery<T>(clazz, this, query);
    }

    @Override
    public <T> IDocumentQuery<T> query(Class<T> clazz) {
        return this.documentQuery(clazz, null, null, false);
    }

    @Override
    public <T> IDocumentQuery<T> query(Class<T> clazz, Query collectionOrIndexName) {
        if (StringUtils.isNotEmpty((CharSequence)collectionOrIndexName.getCollection())) {
            return this.documentQuery(clazz, null, collectionOrIndexName.getCollection(), false);
        }
        return this.documentQuery(clazz, collectionOrIndexName.getIndexName(), null, false);
    }

    @Override
    public <T, TIndex extends AbstractIndexCreationTask> IDocumentQuery<T> query(Class<T> clazz, Class<TIndex> indexClazz) {
        return this.documentQuery(clazz, indexClazz);
    }
}

