/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Defaults;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.ravendb.client.documents.DocumentStoreBase;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.IdTypeAndName;
import net.ravendb.client.documents.commands.GetDocumentsResult;
import net.ravendb.client.documents.commands.batches.BatchOptions;
import net.ravendb.client.documents.commands.batches.CommandType;
import net.ravendb.client.documents.commands.batches.DeleteCommandData;
import net.ravendb.client.documents.commands.batches.ICommandData;
import net.ravendb.client.documents.commands.batches.PutCommandDataWithJson;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.identity.GenerateEntityIdOnTheClient;
import net.ravendb.client.documents.session.AfterStoreEventArgs;
import net.ravendb.client.documents.session.BeforeDeleteEventArgs;
import net.ravendb.client.documents.session.BeforeQueryExecutedEventArgs;
import net.ravendb.client.documents.session.BeforeStoreEventArgs;
import net.ravendb.client.documents.session.DocumentInfo;
import net.ravendb.client.documents.session.DocumentsById;
import net.ravendb.client.documents.session.DocumentsChanges;
import net.ravendb.client.documents.session.EntityToJson;
import net.ravendb.client.documents.session.IMetadataDictionary;
import net.ravendb.client.documents.session.IncludesUtil;
import net.ravendb.client.documents.session.SessionInfo;
import net.ravendb.client.documents.session.operations.lazy.ILazyOperation;
import net.ravendb.client.exceptions.documents.session.NonUniqueObjectException;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.CurrentIndexAndNode;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.RequestExecutor;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.JsonOperation;
import net.ravendb.client.json.MetadataAsDictionary;
import net.ravendb.client.primitives.CleanCloseable;
import net.ravendb.client.primitives.EventHandler;
import net.ravendb.client.primitives.EventHelper;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.primitives.Tuple;
import net.ravendb.client.util.IdentityHashSet;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class InMemoryDocumentSessionOperations
implements CleanCloseable {
    private static final AtomicInteger _clientSessionIdCounter = new AtomicInteger();
    protected final int _clientSessionId = _clientSessionIdCounter.incrementAndGet();
    protected final RequestExecutor _requestExecutor;
    protected final List<ILazyOperation> pendingLazyOperations = new ArrayList<ILazyOperation>();
    protected final Map<ILazyOperation, Consumer<Object>> onEvaluateLazy = new HashMap<ILazyOperation, Consumer<Object>>();
    private static final AtomicInteger _instancesCounter = new AtomicInteger();
    private final int _hash = _instancesCounter.incrementAndGet();
    protected final boolean generateDocumentKeysOnStore = true;
    protected final SessionInfo sessionInfo;
    private BatchOptions _saveChangesOptions;
    private boolean _isDisposed;
    protected ObjectMapper mapper = JsonExtensions.getDefaultMapper();
    private final UUID id;
    protected final Set<Object> deletedEntities = new IdentityHashSet<Object>();
    private final List<EventHandler<BeforeStoreEventArgs>> onBeforeStore = new ArrayList<EventHandler<BeforeStoreEventArgs>>();
    private final List<EventHandler<AfterStoreEventArgs>> onAfterStore = new ArrayList<EventHandler<AfterStoreEventArgs>>();
    private final List<EventHandler<BeforeDeleteEventArgs>> onBeforeDelete = new ArrayList<EventHandler<BeforeDeleteEventArgs>>();
    private final List<EventHandler<BeforeQueryExecutedEventArgs>> onBeforeQueryExecuted = new ArrayList<EventHandler<BeforeQueryExecutedEventArgs>>();
    protected final Set<String> knownMissingIds = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Object> externalState;
    public final DocumentsById documentsById = new DocumentsById();
    public final Map<String, DocumentInfo> includedDocumentsById = new TreeMap<String, DocumentInfo>(String::compareToIgnoreCase);
    public final Map<Object, DocumentInfo> documentsByEntity = new TreeMap<Object, DocumentInfo>((o1, o2) -> o1 == o2 ? 0 : 1);
    protected final DocumentStoreBase _documentStore;
    private final String databaseName;
    private int numberOfRequests;
    private int maxNumberOfRequestsPerSession;
    private boolean useOptimisticConcurrency;
    protected final List<ICommandData> deferredCommands = new ArrayList<ICommandData>();
    protected final Map<IdTypeAndName, ICommandData> deferredCommandsMap = new HashMap<IdTypeAndName, ICommandData>();
    private final GenerateEntityIdOnTheClient generateEntityIdOnTheClient;
    private final EntityToJson entityToJson;

    public UUID getId() {
        return this.id;
    }

    public void addBeforeStoreListener(EventHandler<BeforeStoreEventArgs> handler) {
        this.onBeforeStore.add(handler);
    }

    public void removeBeforeStoreListener(EventHandler<BeforeStoreEventArgs> handler) {
        this.onBeforeStore.remove(handler);
    }

    public void addAfterStoreListener(EventHandler<AfterStoreEventArgs> handler) {
        this.onAfterStore.add(handler);
    }

    public void removeAfterStoreListener(EventHandler<AfterStoreEventArgs> handler) {
        this.onAfterStore.remove(handler);
    }

    public void addBeforeDeleteListener(EventHandler<BeforeDeleteEventArgs> handler) {
        this.onBeforeDelete.add(handler);
    }

    public void removeBeforeDeleteListener(EventHandler<BeforeDeleteEventArgs> handler) {
        this.onBeforeDelete.remove(handler);
    }

    public void addBeforeQueryExecutedListener(EventHandler<BeforeQueryExecutedEventArgs> handler) {
        this.onBeforeQueryExecuted.add(handler);
    }

    public void removeBeforeQueryExecutedListener(EventHandler<BeforeQueryExecutedEventArgs> handler) {
        this.onBeforeQueryExecuted.remove(handler);
    }

    public Map<String, Object> getExternalState() {
        if (this.externalState == null) {
            this.externalState = new HashMap<String, Object>();
        }
        return this.externalState;
    }

    public ServerNode getCurrentSessionNode() {
        CurrentIndexAndNode result;
        switch (this._documentStore.getConventions().getReadBalanceBehavior()) {
            case NONE: {
                result = this._requestExecutor.getPreferredNode();
                break;
            }
            case ROUND_ROBIN: {
                result = this._requestExecutor.getNodeBySessionId(this._clientSessionId);
                break;
            }
            case FASTEST_NODE: {
                result = this._requestExecutor.getFastestNode();
                break;
            }
            default: {
                throw new IllegalArgumentException(this._documentStore.getConventions().getReadBalanceBehavior().toString());
            }
        }
        return result.currentNode;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public IDocumentStore getDocumentStore() {
        return this._documentStore;
    }

    public RequestExecutor getRequestExecutor() {
        return this._requestExecutor;
    }

    public int getNumberOfRequests() {
        return this.numberOfRequests;
    }

    public int getNumberOfEntitiesInUnitOfWork() {
        return this.documentsByEntity.size();
    }

    public String storeIdentifier() {
        return this._documentStore.getIdentifier() + ";" + this.databaseName;
    }

    public DocumentConventions getConventions() {
        return this._requestExecutor.getConventions();
    }

    public int getMaxNumberOfRequestsPerSession() {
        return this.maxNumberOfRequestsPerSession;
    }

    public void setMaxNumberOfRequestsPerSession(int maxNumberOfRequestsPerSession) {
        this.maxNumberOfRequestsPerSession = maxNumberOfRequestsPerSession;
    }

    public boolean isUseOptimisticConcurrency() {
        return this.useOptimisticConcurrency;
    }

    public void setUseOptimisticConcurrency(boolean useOptimisticConcurrency) {
        this.useOptimisticConcurrency = useOptimisticConcurrency;
    }

    public int getDeferredCommandsCount() {
        return this.deferredCommands.size();
    }

    public GenerateEntityIdOnTheClient getGenerateEntityIdOnTheClient() {
        return this.generateEntityIdOnTheClient;
    }

    public EntityToJson getEntityToJson() {
        return this.entityToJson;
    }

    protected InMemoryDocumentSessionOperations(String databaseName, DocumentStoreBase documentStore, RequestExecutor requestExecutor, UUID id) {
        this.id = id;
        this.databaseName = databaseName;
        this._documentStore = documentStore;
        this._requestExecutor = requestExecutor;
        this.useOptimisticConcurrency = requestExecutor.getConventions().isUseOptimisticConcurrency();
        this.maxNumberOfRequestsPerSession = requestExecutor.getConventions().getMaxNumberOfRequestsPerSession();
        this.generateEntityIdOnTheClient = new GenerateEntityIdOnTheClient(this._requestExecutor.getConventions(), this::generateId);
        this.entityToJson = new EntityToJson(this);
        this.sessionInfo = new SessionInfo(this._clientSessionId);
    }

    public <T> IMetadataDictionary getMetadataFor(T instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        DocumentInfo documentInfo = this.getDocumentInfo(instance);
        if (documentInfo.getMetadataInstance() != null) {
            return documentInfo.getMetadataInstance();
        }
        ObjectNode metadataAsJson = documentInfo.getMetadata();
        MetadataAsDictionary metadata = new MetadataAsDictionary(metadataAsJson);
        documentInfo.setMetadataInstance(metadata);
        return metadata;
    }

    public <T> String getChangeVectorFor(T instance) {
        if (instance == null) {
            throw new IllegalArgumentException("instance cannot be null");
        }
        DocumentInfo documentInfo = this.getDocumentInfo(instance);
        JsonNode changeVector = documentInfo.getMetadata().get("@change-vector");
        if (changeVector != null) {
            return changeVector.asText();
        }
        return null;
    }

    private <T> DocumentInfo getDocumentInfo(T instance) {
        DocumentInfo documentInfo = this.documentsByEntity.get(instance);
        if (documentInfo != null) {
            return documentInfo;
        }
        Reference<String> idRef = new Reference<String>();
        if (!this.generateEntityIdOnTheClient.tryGetIdFromInstance(instance, idRef)) {
            throw new IllegalStateException("Could not find the document id for " + instance);
        }
        this.assertNoNonUniqueInstance(instance, (String)idRef.value);
        throw new IllegalArgumentException("Document " + (String)idRef.value + " doesn't exist in the session");
    }

    public boolean isLoaded(String id) {
        return this.isLoadedOrDeleted(id);
    }

    public boolean isLoadedOrDeleted(String id) {
        DocumentInfo documentInfo = this.documentsById.getValue(id);
        return documentInfo != null && documentInfo.getDocument() != null || this.isDeleted(id) || this.includedDocumentsById.containsKey(id);
    }

    public boolean isDeleted(String id) {
        return this.knownMissingIds.contains(id);
    }

    public String getDocumentId(Object instance) {
        if (instance == null) {
            return null;
        }
        DocumentInfo value = this.documentsByEntity.get(instance);
        return value != null ? value.getId() : null;
    }

    public void incrementRequestCount() {
        if (++this.numberOfRequests > this.maxNumberOfRequestsPerSession) {
            throw new IllegalStateException(String.format("The maximum number of requests (%d) allowed for this session has been reached.Raven limits the number of remote calls that a session is allowed to make as an early warning system. Sessions are expected to be short lived, and Raven provides facilities like load(String[] keys) to load multiple documents at once and batch saves (call SaveChanges() only once).You can increase the limit by setting DocumentConvention.MaxNumberOfRequestsPerSession or MaxNumberOfRequestsPerSession, but it isadvisable that you'll look into reducing the number of remote calls first, since that will speed up your application significantly and result in amore responsive application.", this.maxNumberOfRequestsPerSession));
        }
    }

    public <T> T trackEntity(Class<T> clazz, DocumentInfo documentFound) {
        return (T)this.trackEntity(clazz, documentFound.getId(), documentFound.getDocument(), documentFound.getMetadata(), false);
    }

    public Object trackEntity(Class entityType, String id, ObjectNode document, ObjectNode metadata, boolean noTracking) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return this.deserializeFromTransformer(entityType, null, document);
        }
        DocumentInfo docInfo = this.documentsById.getValue(id);
        if (docInfo != null) {
            if (docInfo.getEntity() == null) {
                docInfo.setEntity(this.convertToEntity(entityType, id, document));
            }
            if (!noTracking) {
                this.includedDocumentsById.remove(id);
                this.documentsByEntity.put(docInfo.getEntity(), docInfo);
            }
            return docInfo.getEntity();
        }
        docInfo = this.includedDocumentsById.get(id);
        if (docInfo != null) {
            if (docInfo.getEntity() == null) {
                docInfo.setEntity(this.convertToEntity(entityType, id, document));
            }
            if (!noTracking) {
                this.includedDocumentsById.remove(id);
                this.documentsById.add(docInfo);
                this.documentsByEntity.put(docInfo.getEntity(), docInfo);
            }
            return docInfo.getEntity();
        }
        Object entity = this.convertToEntity(entityType, id, document);
        String changeVector = metadata.get("@change-vector").asText();
        if (changeVector == null) {
            throw new IllegalStateException("Document " + id + " must have Change Vector");
        }
        if (!noTracking) {
            DocumentInfo newDocumentInfo = new DocumentInfo();
            newDocumentInfo.setId(id);
            newDocumentInfo.setDocument(document);
            newDocumentInfo.setMetadata(metadata);
            newDocumentInfo.setEntity(entity);
            newDocumentInfo.setChangeVector(changeVector);
            this.documentsById.add(newDocumentInfo);
            this.documentsByEntity.put(entity, newDocumentInfo);
        }
        return entity;
    }

    public Object convertToEntity(Class entityType, String id, ObjectNode documentFound) {
        return this.entityToJson.convertToEntity(entityType, id, documentFound);
    }

    public static Object getDefaultValue(Class clazz) {
        return Defaults.defaultValue((Class)clazz);
    }

    public <T> void delete(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        DocumentInfo value = this.documentsByEntity.get(entity);
        if (value == null) {
            throw new IllegalStateException(entity + " is not associated with the session, cannot delete unknown entity instance");
        }
        this.deletedEntities.add(entity);
        this.includedDocumentsById.remove(value.getId());
        this.knownMissingIds.add(value.getId());
    }

    public void delete(String id) {
        this.delete(id, null);
    }

    public void delete(String id, String expectedChangeVector) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        String changeVector = null;
        DocumentInfo documentInfo = this.documentsById.getValue(id);
        if (documentInfo != null) {
            ObjectNode newObj = this.entityToJson.convertEntityToJson(documentInfo.getEntity(), documentInfo);
            if (documentInfo.getEntity() != null && this.entityChanged(newObj, documentInfo, null)) {
                throw new IllegalStateException("Can't delete changed entity using identifier. Use delete(Class clazz, T entity) instead.");
            }
            if (documentInfo.getEntity() != null) {
                this.documentsByEntity.remove(documentInfo.getEntity());
            }
            this.documentsById.remove(id);
            changeVector = documentInfo.getChangeVector();
        }
        this.knownMissingIds.add(id);
        changeVector = this.isUseOptimisticConcurrency() ? changeVector : null;
        this.defer(new DeleteCommandData(id, (String)ObjectUtils.firstNonNull((Object[])new String[]{expectedChangeVector, changeVector})), new ICommandData[0]);
    }

    public void store(Object entity) {
        Reference<String> stringReference = new Reference<String>();
        boolean hasId = this.generateEntityIdOnTheClient.tryGetIdFromInstance(entity, stringReference);
        this.storeInternal(entity, null, null, !hasId ? ConcurrencyCheckMode.FORCED : ConcurrencyCheckMode.AUTO);
    }

    public void store(Object entity, String id) {
        this.storeInternal(entity, null, id, ConcurrencyCheckMode.AUTO);
    }

    public void store(Object entity, String changeVector, String id) {
        this.storeInternal(entity, changeVector, id, changeVector == null ? ConcurrencyCheckMode.DISABLED : ConcurrencyCheckMode.FORCED);
    }

    private void storeInternal(Object entity, String changeVector, String id, ConcurrencyCheckMode forceConcurrencyCheck) {
        String javaType;
        if (null == entity) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        DocumentInfo value = this.documentsByEntity.get(entity);
        if (value != null) {
            value.setChangeVector((String)ObjectUtils.firstNonNull((Object[])new String[]{changeVector, value.getChangeVector()}));
            value.setConcurrencyCheckMode(forceConcurrencyCheck);
            return;
        }
        if (id == null) {
            id = this.generateEntityIdOnTheClient.generateDocumentKeyForStorage(entity);
        } else {
            this.generateEntityIdOnTheClient.trySetIdentity(entity, id);
        }
        if (this.deferredCommandsMap.containsKey(IdTypeAndName.create(id, CommandType.CLIENT_ANY_COMMAND, null))) {
            throw new IllegalStateException("Can't store document, there is a deferred command registered for this document in the session. Document id: " + id);
        }
        if (this.deletedEntities.contains(entity)) {
            throw new IllegalStateException("Can't store object, it was already deleted in this session.  Document id: " + id);
        }
        this.assertNoNonUniqueInstance(entity, id);
        String tag = this._requestExecutor.getConventions().getCollectionName(entity);
        ObjectMapper mapper = JsonExtensions.getDefaultMapper();
        ObjectNode metadata = mapper.createObjectNode();
        if (tag != null) {
            metadata.set("@collection", (JsonNode)mapper.convertValue((Object)tag, JsonNode.class));
        }
        if ((javaType = this._requestExecutor.getConventions().getJavaClassName(entity.getClass())) != null) {
            metadata.set("Raven-Java-Type", (JsonNode)mapper.convertValue((Object)javaType, TextNode.class));
        }
        if (id != null) {
            this.knownMissingIds.remove(id);
        }
        this.storeEntityInUnitOfWork(id, entity, changeVector, metadata, forceConcurrencyCheck);
    }

    protected abstract String generateId(Object var1);

    protected void rememberEntityForDocumentIdGeneration(Object entity) {
        throw new NotImplementedException("You cannot set GenerateDocumentIdsOnStore to false without implementing RememberEntityForDocumentIdGeneration");
    }

    protected void storeEntityInUnitOfWork(String id, Object entity, String changeVector, ObjectNode metadata, ConcurrencyCheckMode forceConcurrencyCheck) {
        this.deletedEntities.remove(entity);
        if (id != null) {
            this.knownMissingIds.remove(id);
        }
        DocumentInfo documentInfo = new DocumentInfo();
        documentInfo.setId(id);
        documentInfo.setMetadata(metadata);
        documentInfo.setChangeVector(changeVector);
        documentInfo.setConcurrencyCheckMode(forceConcurrencyCheck);
        documentInfo.setEntity(entity);
        documentInfo.setNewDocument(true);
        documentInfo.setDocument(null);
        this.documentsByEntity.put(entity, documentInfo);
        if (id != null) {
            this.documentsById.add(documentInfo);
        }
    }

    protected void assertNoNonUniqueInstance(Object entity, String id) {
        if (StringUtils.isEmpty((CharSequence)id) || id.charAt(id.length() - 1) == '|' || id.charAt(id.length() - 1) == '/') {
            return;
        }
        DocumentInfo info = this.documentsById.getValue(id);
        if (info == null || info.getEntity() == entity) {
            return;
        }
        throw new NonUniqueObjectException("Attempted to associate a different object with id '" + id + "'.");
    }

    public SaveChangesData prepareForSaveChanges() {
        SaveChangesData result = new SaveChangesData(this);
        this.deferredCommands.clear();
        this.deferredCommandsMap.clear();
        this.prepareForEntitiesDeletion(result, null);
        this.prepareForEntitiesPuts(result);
        return result;
    }

    private static void updateMetadataModifications(DocumentInfo documentInfo) {
        ObjectMapper mapper = JsonExtensions.getDefaultMapper();
        if (documentInfo.getMetadataInstance() != null) {
            for (String prop : documentInfo.getMetadataInstance().keySet()) {
                documentInfo.getMetadata().set(prop, (JsonNode)mapper.convertValue(documentInfo.getMetadataInstance().get(prop), JsonNode.class));
            }
        }
    }

    private void prepareForEntitiesDeletion(SaveChangesData result, Map<String, List<DocumentsChanges>> changes) {
        for (Object deletedEntity : this.deletedEntities) {
            DocumentInfo documentInfo = this.documentsByEntity.get(deletedEntity);
            if (documentInfo == null) continue;
            if (changes != null) {
                ArrayList<DocumentsChanges> docChanges = new ArrayList<DocumentsChanges>();
                DocumentsChanges change = new DocumentsChanges();
                change.setFieldNewValue("");
                change.setFieldOldValue("");
                change.setChange(DocumentsChanges.ChangeType.DOCUMENT_DELETED);
                docChanges.add(change);
                changes.put(documentInfo.getId(), docChanges);
            } else {
                ICommandData command = result.getDeferredCommandsMap().get(IdTypeAndName.create(documentInfo.getId(), CommandType.CLIENT_ANY_COMMAND, null));
                if (command != null) {
                    InMemoryDocumentSessionOperations.throwInvalidDeletedDocumentWithDeferredCommand(command);
                }
                String changeVector = null;
                if ((documentInfo = this.documentsById.getValue(documentInfo.getId())) != null) {
                    changeVector = documentInfo.getChangeVector();
                    if (documentInfo.getEntity() != null) {
                        AfterStoreEventArgs afterStoreEventArgs = new AfterStoreEventArgs(this, documentInfo.getId(), documentInfo.getEntity());
                        EventHelper.invoke(this.onAfterStore, this, afterStoreEventArgs);
                        this.documentsByEntity.remove(documentInfo.getEntity());
                        result.getEntities().add(documentInfo.getEntity());
                    }
                    this.documentsById.remove(documentInfo.getId());
                }
                changeVector = this.useOptimisticConcurrency ? changeVector : null;
                BeforeDeleteEventArgs beforeDeleteEventArgs = new BeforeDeleteEventArgs(this, documentInfo.getId(), documentInfo.getEntity());
                EventHelper.invoke(this.onBeforeDelete, this, beforeDeleteEventArgs);
                result.getSessionCommands().add(new DeleteCommandData(documentInfo.getId(), changeVector));
            }
            if (changes != null) continue;
            this.deletedEntities.clear();
        }
    }

    private void prepareForEntitiesPuts(SaveChangesData result) {
        for (Map.Entry<Object, DocumentInfo> entity : this.documentsByEntity.entrySet()) {
            List onBeforeStore;
            InMemoryDocumentSessionOperations.updateMetadataModifications(entity.getValue());
            ObjectNode document = this.entityToJson.convertEntityToJson(entity.getKey(), entity.getValue());
            if (entity.getValue().isIgnoreChanges() || !this.entityChanged(document, entity.getValue(), null)) continue;
            ICommandData command = (ICommandData)result.deferredCommandsMap.get(IdTypeAndName.create(entity.getValue().getId(), CommandType.CLIENT_ANY_COMMAND, null));
            if (command != null) {
                InMemoryDocumentSessionOperations.throwInvalidModifiedDocumentWithDeferredCommand(command);
            }
            if ((onBeforeStore = this.onBeforeStore) != null && !onBeforeStore.isEmpty()) {
                BeforeStoreEventArgs beforeStoreEventArgs = new BeforeStoreEventArgs(this, entity.getValue().getId(), entity.getKey());
                EventHelper.invoke(onBeforeStore, this, beforeStoreEventArgs);
                if (beforeStoreEventArgs.isMetadataAccessed()) {
                    InMemoryDocumentSessionOperations.updateMetadataModifications(entity.getValue());
                }
                if (beforeStoreEventArgs.isMetadataAccessed() || this.entityChanged(document, entity.getValue(), null)) {
                    document = this.entityToJson.convertEntityToJson(entity.getKey(), entity.getValue());
                }
            }
            entity.getValue().setNewDocument(false);
            result.getEntities().add(entity.getKey());
            if (entity.getValue().getId() != null) {
                this.documentsById.remove(entity.getValue().getId());
            }
            entity.getValue().setDocument(document);
            String changeVector = this.useOptimisticConcurrency ? (entity.getValue().getConcurrencyCheckMode() != ConcurrencyCheckMode.DISABLED ? (String)ObjectUtils.firstNonNull((Object[])new String[]{entity.getValue().getChangeVector(), ""}) : null) : (entity.getValue().getConcurrencyCheckMode() == ConcurrencyCheckMode.FORCED ? entity.getValue().getChangeVector() : null);
            result.getSessionCommands().add(new PutCommandDataWithJson(entity.getValue().getId(), changeVector, document));
        }
    }

    private static void throwInvalidModifiedDocumentWithDeferredCommand(ICommandData resultCommand) {
        throw new IllegalStateException("Cannot perform save because document " + resultCommand.getId() + " has been deleted by the session and is also taking part in deferred " + (Object)((Object)resultCommand.getType()) + " command");
    }

    private static void throwInvalidDeletedDocumentWithDeferredCommand(ICommandData resultCommand) {
        throw new IllegalStateException("Cannot perform save because document " + resultCommand.getId() + " has been deleted by the session and is also taking part in deferred " + (Object)((Object)resultCommand.getType()) + " command");
    }

    protected boolean entityChanged(ObjectNode newObj, DocumentInfo documentInfo, Map<String, List<DocumentsChanges>> changes) {
        return JsonOperation.entityChanged(newObj, documentInfo, changes);
    }

    public Map<String, List<DocumentsChanges>> whatChanged() {
        HashMap<String, List<DocumentsChanges>> changes = new HashMap<String, List<DocumentsChanges>>();
        this.prepareForEntitiesDeletion(null, changes);
        this.getAllEntitiesChanges(changes);
        return changes;
    }

    public boolean hasChanges() {
        for (Map.Entry<Object, DocumentInfo> entity : this.documentsByEntity.entrySet()) {
            ObjectNode document = this.entityToJson.convertEntityToJson(entity.getKey(), entity.getValue());
            if (!this.entityChanged(document, entity.getValue(), null)) continue;
            return true;
        }
        return !this.deletedEntities.isEmpty();
    }

    public boolean hasChanged(Object entity) {
        DocumentInfo documentInfo = this.documentsByEntity.get(entity);
        if (documentInfo == null) {
            return false;
        }
        ObjectNode document = this.entityToJson.convertEntityToJson(entity, documentInfo);
        return this.entityChanged(document, documentInfo, null);
    }

    private void getAllEntitiesChanges(Map<String, List<DocumentsChanges>> changes) {
        for (Map.Entry<String, DocumentInfo> pair : this.documentsById) {
            InMemoryDocumentSessionOperations.updateMetadataModifications(pair.getValue());
            ObjectNode newObj = this.entityToJson.convertEntityToJson(pair.getValue().getEntity(), pair.getValue());
            this.entityChanged(newObj, pair.getValue(), changes);
        }
    }

    public void ignoreChangesFor(Object entity) {
        this.getDocumentInfo(entity).setIgnoreChanges(true);
    }

    public <T> void evict(T entity) {
        DocumentInfo documentInfo = this.documentsByEntity.get(entity);
        if (documentInfo != null) {
            this.documentsByEntity.remove(entity);
            this.documentsById.remove(documentInfo.getId());
        }
        this.deletedEntities.remove(entity);
    }

    public void clear() {
        this.documentsByEntity.clear();
        this.deletedEntities.clear();
        this.documentsById.clear();
        this.knownMissingIds.clear();
        this.includedDocumentsById.clear();
    }

    public void defer(ICommandData command, ICommandData ... commands) {
        this.deferredCommands.add(command);
        this.deferInternal(command);
        if (commands != null && commands.length > 0) {
            this.defer(commands);
        }
    }

    public void defer(ICommandData[] commands) {
        this.deferredCommands.addAll(Arrays.asList(commands));
        for (ICommandData command : commands) {
            this.deferInternal(command);
        }
    }

    private void deferInternal(ICommandData command) {
        this.deferredCommandsMap.put(IdTypeAndName.create(command.getId(), command.getType(), command.getName()), command);
        this.deferredCommandsMap.put(IdTypeAndName.create(command.getId(), CommandType.CLIENT_ANY_COMMAND, null), command);
        if (!CommandType.ATTACHMENT_PUT.equals((Object)command.getType())) {
            this.deferredCommandsMap.put(IdTypeAndName.create(command.getId(), CommandType.CLIENT_NOT_ATTACHMENT_PUT, null), command);
        }
    }

    private void close(boolean isDisposing) {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
    }

    @Override
    public void close() {
        this.close(true);
    }

    public void registerMissing(String id) {
        this.knownMissingIds.add(id);
    }

    public void unregisterMissing(String id) {
        this.knownMissingIds.remove(id);
    }

    public void registerIncludes(ObjectNode includes) {
        if (includes == null) {
            return;
        }
        for (String fieldName : Lists.newArrayList((Iterator)includes.fieldNames())) {
            ObjectNode json;
            DocumentInfo newDocumentInfo;
            JsonNode fieldValue = includes.get(fieldName);
            if (fieldValue == null || JsonExtensions.tryGetConflict((JsonNode)(newDocumentInfo = DocumentInfo.getNewDocumentInfo(json = (ObjectNode)fieldValue)).getMetadata())) continue;
            this.includedDocumentsById.put(newDocumentInfo.getId(), newDocumentInfo);
        }
    }

    public void registerMissingIncludes(ArrayNode results, ObjectNode includes, String[] includePaths) {
        if (includePaths == null || includePaths.length == 0) {
            return;
        }
        for (JsonNode result : results) {
            for (String include : includePaths) {
                if ("id()".equals(include)) continue;
                IncludesUtil.include((ObjectNode)result, include, id -> {
                    JsonNode metadata;
                    if (id == null) {
                        return;
                    }
                    if (this.isLoaded((String)id)) {
                        return;
                    }
                    JsonNode document = includes.get(id);
                    if (document != null && JsonExtensions.tryGetConflict(metadata = document.get("@metadata"))) {
                        return;
                    }
                    this.registerMissing((String)id);
                });
            }
        }
    }

    public int hashCode() {
        return this._hash;
    }

    private Object deserializeFromTransformer(Class clazz, String id, ObjectNode document) {
        return this.entityToJson.convertToEntity(clazz, id, document);
    }

    public boolean checkIfIdAlreadyIncluded(String[] ids, Map.Entry<String, Class>[] includes) {
        return this.checkIfIdAlreadyIncluded(ids, Arrays.stream(includes).map(Map.Entry::getKey).collect(Collectors.toList()));
    }

    public boolean checkIfIdAlreadyIncluded(String[] ids, Collection<String> includes) {
        for (String id : ids) {
            if (this.knownMissingIds.contains(id)) continue;
            DocumentInfo documentInfo = this.documentsById.getValue(id);
            if (documentInfo == null && (documentInfo = this.includedDocumentsById.get(id)) == null) {
                return false;
            }
            if (documentInfo.getEntity() == null) {
                return false;
            }
            if (includes == null) continue;
            for (String include : includes) {
                boolean[] hasAll = new boolean[]{true};
                IncludesUtil.include(documentInfo.getDocument(), include, s -> {
                    hasAll[0] = hasAll[0] & this.isLoaded((String)s);
                });
                if (hasAll[0]) continue;
                return false;
            }
        }
        return true;
    }

    protected <T> void refreshInternal(T entity, RavenCommand<GetDocumentsResult> cmd, DocumentInfo documentInfo) {
        ObjectNode document = (ObjectNode)cmd.getResult().getResults().get(0);
        if (document == null) {
            throw new IllegalStateException("Document '" + documentInfo.getId() + "' no longer exists and was probably deleted");
        }
        ObjectNode value = (ObjectNode)document.get("@metadata");
        documentInfo.setMetadata(value);
        if (documentInfo.getMetadata() != null) {
            JsonNode changeVector = value.get("@change-vector");
            documentInfo.setChangeVector(changeVector.asText());
        }
        documentInfo.setDocument(document);
        documentInfo.setEntity(this.convertToEntity(entity.getClass(), documentInfo.getId(), document));
        try {
            BeanUtils.copyProperties(entity, (Object)documentInfo.getEntity());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to refresh entity: " + e.getMessage(), e);
        }
    }

    public void onAfterStoreInvoke(AfterStoreEventArgs afterStoreEventArgs) {
        EventHelper.invoke(this.onAfterStore, this, afterStoreEventArgs);
    }

    public void onBeforeQueryExecutedInvoke(BeforeQueryExecutedEventArgs beforeQueryExecutedEventArgs) {
        EventHelper.invoke(this.onBeforeQueryExecuted, this, beforeQueryExecutedEventArgs);
    }

    protected Tuple<String, String> processQueryParameters(Class clazz, String indexName, String collectionName, DocumentConventions conventions) {
        boolean isIndex = StringUtils.isNotBlank((CharSequence)indexName);
        boolean isCollection = StringUtils.isNotEmpty((CharSequence)collectionName);
        if (isIndex && isCollection) {
            throw new IllegalStateException("Parameters indexName and collectionName are mutually exclusive. Please specify only one of them.");
        }
        if (!isIndex && !isCollection) {
            collectionName = conventions.getCollectionName(clazz);
        }
        return Tuple.create(indexName, collectionName);
    }

    protected void throwEntityNotInSession(Object entity) {
        throw new IllegalArgumentException(entity + " is not associated with the session, cannot add attachment to it. Use documentId instead or track the entity in the session.");
    }

    public static class SaveChangesData {
        private final List<ICommandData> deferredCommands;
        private final Map<IdTypeAndName, ICommandData> deferredCommandsMap;
        private final List<ICommandData> sessionCommands = new ArrayList<ICommandData>();
        private final List<Object> entities = new ArrayList<Object>();
        private final BatchOptions options;

        public SaveChangesData(InMemoryDocumentSessionOperations session) {
            this.deferredCommands = new ArrayList<ICommandData>(session.deferredCommands);
            this.deferredCommandsMap = new HashMap<IdTypeAndName, ICommandData>(session.deferredCommandsMap);
            this.options = session._saveChangesOptions;
        }

        public List<ICommandData> getDeferredCommands() {
            return this.deferredCommands;
        }

        public List<ICommandData> getSessionCommands() {
            return this.sessionCommands;
        }

        public List<Object> getEntities() {
            return this.entities;
        }

        public BatchOptions getOptions() {
            return this.options;
        }

        public Map<IdTypeAndName, ICommandData> getDeferredCommandsMap() {
            return this.deferredCommandsMap;
        }
    }

    public static enum ConcurrencyCheckMode {
        AUTO,
        FORCED,
        DISABLED;

    }
}

