/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import net.ravendb.client.documents.commands.batches.BatchCommand;
import net.ravendb.client.documents.session.AfterStoreEventArgs;
import net.ravendb.client.documents.session.DocumentInfo;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;
import net.ravendb.client.json.JsonArrayResult;

public class BatchOperation {
    private final InMemoryDocumentSessionOperations _session;
    private List<Object> _entities;
    private int _sessionCommandsCount;

    public BatchOperation(InMemoryDocumentSessionOperations session) {
        this._session = session;
    }

    public BatchCommand createRequest() {
        InMemoryDocumentSessionOperations.SaveChangesData result = this._session.prepareForSaveChanges();
        this._sessionCommandsCount = result.getSessionCommands().size();
        result.getSessionCommands().addAll(result.getDeferredCommands());
        if (result.getSessionCommands().isEmpty()) {
            return null;
        }
        this._session.incrementRequestCount();
        this._entities = result.getEntities();
        return new BatchCommand(this._session.getConventions(), result.getSessionCommands(), result.getOptions());
    }

    public void setResult(JsonArrayResult result) {
        if (result.getResults() == null) {
            BatchOperation.throwOnNullResults();
            return;
        }
        for (int i = 0; i < this._sessionCommandsCount; ++i) {
            Object entity;
            DocumentInfo documentInfo;
            ObjectNode batchResult = (ObjectNode)result.getResults().get(i);
            if (batchResult == null) {
                throw new IllegalArgumentException();
            }
            String type = batchResult.get("Type").asText();
            if (!"PUT".equals(type) || (documentInfo = this._session.documentsByEntity.get(entity = this._entities.get(i))) == null) continue;
            String changeVector = batchResult.get("@change-vector").asText();
            if (changeVector == null) {
                throw new IllegalStateException("PUT response is invalid. @change-vector is missing on " + documentInfo.getId());
            }
            String id = batchResult.get("@id").asText();
            if (id == null) {
                throw new IllegalStateException("PUT response is invalid. @id is missing on " + documentInfo.getId());
            }
            batchResult.fieldNames().forEachRemaining(propertyName -> {
                if ("Type".equals(propertyName)) {
                    return;
                }
                documentInfo.getMetadata().set(propertyName, batchResult.get(propertyName));
            });
            documentInfo.setId(id);
            documentInfo.setChangeVector(changeVector);
            documentInfo.getDocument().set("@metadata", (JsonNode)documentInfo.getMetadata());
            documentInfo.setMetadataInstance(null);
            this._session.documentsById.add(documentInfo);
            this._session.getGenerateEntityIdOnTheClient().trySetIdentity(entity, id);
            AfterStoreEventArgs afterStoreEventArgs = new AfterStoreEventArgs(this._session, documentInfo.getId(), documentInfo.getEntity());
            this._session.onAfterStoreInvoke(afterStoreEventArgs);
        }
    }

    private static void throwOnNullResults() {
        throw new IllegalStateException("Received empty response from the server. This is not supposed to happen and is likely a bug.");
    }
}

