/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Defaults;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ravendb.client.documents.commands.GetRevisionsCommand;
import net.ravendb.client.documents.session.DocumentInfo;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;
import net.ravendb.client.json.MetadataAsDictionary;

public class GetRevisionOperation {
    private final InMemoryDocumentSessionOperations _session;
    private ArrayNode _result;
    private final GetRevisionsCommand _command;

    public GetRevisionOperation(InMemoryDocumentSessionOperations session, String id, Integer start, Integer pageSize) {
        this(session, id, start, pageSize, false);
    }

    public GetRevisionOperation(InMemoryDocumentSessionOperations session, String id, Integer start, Integer pageSize, boolean metadataOnly) {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        this._session = session;
        this._command = new GetRevisionsCommand(id, start, pageSize, metadataOnly);
    }

    public GetRevisionOperation(InMemoryDocumentSessionOperations session, String changeVector) {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null");
        }
        this._session = session;
        this._command = new GetRevisionsCommand(changeVector);
    }

    public GetRevisionOperation(InMemoryDocumentSessionOperations session, String[] changeVector) {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null");
        }
        this._session = session;
        this._command = new GetRevisionsCommand(changeVector);
    }

    public GetRevisionsCommand createRequest() {
        return this._command;
    }

    public void setResult(ArrayNode result) {
        this._result = result;
    }

    public <T> T getRevision(Class<T> clazz, ObjectNode document) {
        JsonNode changeVectorNode;
        JsonNode idNode;
        if (document == null) {
            return (T)Defaults.defaultValue(clazz);
        }
        ObjectNode metadata = null;
        String id = null;
        if (document.has("@metadata") && (idNode = (metadata = (ObjectNode)document.get("@metadata")).get("@id")) != null) {
            id = idNode.asText();
        }
        String changeVector = null;
        if (metadata != null && metadata.has("@change-vector") && (changeVectorNode = metadata.get("@change-vector")) != null) {
            changeVector = changeVectorNode.asText();
        }
        Object entity = this._session.convertToEntity(clazz, id, document);
        DocumentInfo documentInfo = new DocumentInfo();
        documentInfo.setId(id);
        documentInfo.setChangeVector(changeVector);
        documentInfo.setDocument(document);
        documentInfo.setEntity(entity);
        this._session.documentsByEntity.put(entity, documentInfo);
        return (T)entity;
    }

    public <T> List<T> getRevisionsFor(Class<T> clazz) {
        int resultsCount = this._result.get("Results").size();
        ArrayList<T> results = new ArrayList<T>(resultsCount);
        for (int i = 0; i < resultsCount; ++i) {
            ObjectNode document = (ObjectNode)this._result.get("Results").get(i);
            results.add(this.getRevision(clazz, document));
        }
        return results;
    }

    public List<MetadataAsDictionary> getRevisionsMetadataFor() {
        int resultsCount = this._result.get("Results").size();
        ArrayList<MetadataAsDictionary> results = new ArrayList<MetadataAsDictionary>(resultsCount);
        for (int i = 0; i < resultsCount; ++i) {
            ObjectNode document = (ObjectNode)this._result.get("Results").get(i);
            ObjectNode metadata = null;
            if (document.has("@metadata")) {
                metadata = (ObjectNode)document.get("@metadata");
            }
            results.add(new MetadataAsDictionary(metadata));
        }
        return results;
    }

    public <T> T getRevision(Class<T> clazz) {
        if (this._result == null) {
            return (T)Defaults.defaultValue(clazz);
        }
        ObjectNode document = (ObjectNode)this._result.get("Results").get(0);
        return this.getRevision(clazz, document);
    }

    public <T> Map<String, T> getRevisions(Class<T> clazz) {
        TreeMap<String, T> results = new TreeMap<String, T>(String::compareToIgnoreCase);
        for (int i = 0; i < this._command.getChangeVectors().length; ++i) {
            String changeVector = this._command.getChangeVectors()[i];
            if (changeVector == null) continue;
            results.put(changeVector, this.getRevision(clazz, (ObjectNode)this._result.get(i)));
        }
        return results;
    }
}

