/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Defaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.ravendb.client.documents.commands.GetDocumentsCommand;
import net.ravendb.client.documents.commands.GetDocumentsResult;
import net.ravendb.client.documents.session.DocumentInfo;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadOperation {
    private final InMemoryDocumentSessionOperations _session;
    private static final Log logger = LogFactory.getLog(LoadOperation.class);
    private String[] _ids;
    private String[] _includes;
    private final List<String> _idsToCheckOnServer = new ArrayList<String>();

    public LoadOperation(InMemoryDocumentSessionOperations _session) {
        this._session = _session;
    }

    public GetDocumentsCommand createRequest() {
        if (this._idsToCheckOnServer.size() == 0) {
            return null;
        }
        if (this._session.checkIfIdAlreadyIncluded(this._ids, this._includes != null ? Arrays.asList(this._includes) : null)) {
            return null;
        }
        this._session.incrementRequestCount();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Requesting the following ids " + String.join((CharSequence)",", this._idsToCheckOnServer) + " from " + this._session.storeIdentifier()));
        }
        return new GetDocumentsCommand(this._idsToCheckOnServer.toArray(new String[0]), this._includes, false);
    }

    public LoadOperation byId(String id) {
        if (id == null) {
            return this;
        }
        if (this._ids == null) {
            this._ids = new String[]{id};
        }
        if (this._session.isLoadedOrDeleted(id)) {
            return this;
        }
        this._idsToCheckOnServer.add(id);
        return this;
    }

    public LoadOperation withIncludes(String[] includes) {
        this._includes = includes;
        return this;
    }

    public LoadOperation byIds(String[] ids) {
        return this.byIds(Arrays.asList(ids));
    }

    public LoadOperation byIds(Collection<String> ids) {
        this._ids = ids.toArray(new String[0]);
        TreeSet<String> distinct = new TreeSet<String>(String::compareToIgnoreCase);
        for (String id : ids) {
            if (id == null) continue;
            distinct.add(id);
        }
        for (String id : distinct) {
            this.byId(id);
        }
        return this;
    }

    public <T> T getDocument(Class<T> clazz) {
        return this.getDocument(clazz, this._ids[0]);
    }

    private <T> T getDocument(Class<T> clazz, String id) {
        if (id == null) {
            return (T)Defaults.defaultValue(clazz);
        }
        if (this._session.isDeleted(id)) {
            return (T)Defaults.defaultValue(clazz);
        }
        DocumentInfo doc = this._session.documentsById.getValue(id);
        if (doc != null) {
            return this._session.trackEntity(clazz, doc);
        }
        doc = this._session.includedDocumentsById.get(id);
        if (doc != null) {
            return this._session.trackEntity(clazz, doc);
        }
        return (T)Defaults.defaultValue(clazz);
    }

    public <T> Map<String, T> getDocuments(Class<T> clazz) {
        TreeMap<String, T> finalResults = new TreeMap<String, T>(String::compareToIgnoreCase);
        for (String id : this._ids) {
            if (id == null) continue;
            finalResults.put(id, this.getDocument(clazz, id));
        }
        return finalResults;
    }

    public void setResult(GetDocumentsResult result) {
        if (result == null) {
            return;
        }
        this._session.registerIncludes(result.getIncludes());
        for (JsonNode document : result.getResults()) {
            if (document == null || document.isNull()) continue;
            DocumentInfo newDocumentInfo = DocumentInfo.getNewDocumentInfo((ObjectNode)document);
            this._session.documentsById.add(newDocumentInfo);
        }
        this._session.registerMissingIncludes(result.getResults(), result.getIncludes(), this._includes);
    }
}

