/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Defaults;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.ravendb.client.documents.commands.GetDocumentsCommand;
import net.ravendb.client.documents.commands.GetDocumentsResult;
import net.ravendb.client.documents.session.DocumentInfo;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadStartingWithOperation {
    private static final Log logger = LogFactory.getLog(LoadStartingWithOperation.class);
    private final InMemoryDocumentSessionOperations _session;
    private String _startWith;
    private String _matches;
    private int _start;
    private int _pageSize;
    private String _exclude;
    private String _startAfter;
    private final List<String> _returnedIds = new ArrayList<String>();

    public LoadStartingWithOperation(InMemoryDocumentSessionOperations session) {
        this._session = session;
    }

    public GetDocumentsCommand createRequest() {
        this._session.incrementRequestCount();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Requesting documents with ids starting with '" + this._startWith + "' from " + this._session.storeIdentifier()));
        }
        return new GetDocumentsCommand(this._startWith, this._startAfter, this._matches, this._exclude, this._start, this._pageSize, false);
    }

    public void withStartWith(String idPrefix) {
        this.withStartWith(idPrefix, null);
    }

    public void withStartWith(String idPrefix, String matches) {
        this.withStartWith(idPrefix, matches, 0);
    }

    public void withStartWith(String idPrefix, String matches, int start) {
        this.withStartWith(idPrefix, matches, start, 25);
    }

    public void withStartWith(String idPrefix, String matches, int start, int pageSize) {
        this.withStartWith(idPrefix, matches, start, pageSize, null);
    }

    public void withStartWith(String idPrefix, String matches, int start, int pageSize, String exclude) {
        this.withStartWith(idPrefix, matches, start, pageSize, exclude, null);
    }

    public void withStartWith(String idPrefix, String matches, int start, int pageSize, String exclude, String startAfter) {
        this._startWith = idPrefix;
        this._matches = matches;
        this._start = start;
        this._pageSize = pageSize;
        this._exclude = exclude;
        this._startAfter = startAfter;
    }

    public void setResult(GetDocumentsResult result) {
        for (JsonNode document : result.getResults()) {
            DocumentInfo newDocumentInfo = DocumentInfo.getNewDocumentInfo((ObjectNode)document);
            this._session.documentsById.add(newDocumentInfo);
            this._returnedIds.add(newDocumentInfo.getId());
        }
    }

    public <T> T[] getDocuments(Class<T> clazz) {
        int i = 0;
        Object[] finalResults = (Object[])Array.newInstance(clazz, this._returnedIds.size());
        for (String id : this._returnedIds) {
            finalResults[i++] = this.getDocument(clazz, id);
        }
        return finalResults;
    }

    private <T> T getDocument(Class<T> clazz, String id) {
        if (id == null) {
            return (T)Defaults.defaultValue(clazz);
        }
        if (this._session.isDeleted(id)) {
            return (T)Defaults.defaultValue(clazz);
        }
        DocumentInfo doc = this._session.documentsById.getValue(id);
        if (doc != null) {
            return this._session.trackEntity(clazz, doc);
        }
        return (T)Defaults.defaultValue(clazz);
    }
}

