/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session.tokens;

import net.ravendb.client.documents.session.tokens.QueryToken;

public class FieldsToFetchToken
extends QueryToken {
    public final String[] fieldsToFetch;
    public final String[] projections;
    public final boolean customFunction;

    private FieldsToFetchToken(String[] fieldsToFetch, String[] projections, boolean customFunction) {
        this.fieldsToFetch = fieldsToFetch;
        this.projections = projections;
        this.customFunction = customFunction;
    }

    public static FieldsToFetchToken create(String[] fieldsToFetch, String[] projections, boolean customFunction) {
        if (fieldsToFetch == null || fieldsToFetch.length == 0) {
            throw new IllegalArgumentException("fieldToFetch cannot be null");
        }
        if (!customFunction && projections != null && projections.length != fieldsToFetch.length) {
            throw new IllegalArgumentException("Length of projections must be the same as length of field to fetch");
        }
        return new FieldsToFetchToken(fieldsToFetch, projections, customFunction);
    }

    @Override
    public void writeTo(StringBuilder writer) {
        for (int i = 0; i < this.fieldsToFetch.length; ++i) {
            String projection;
            String fieldToFetch = this.fieldsToFetch[i];
            String string = projection = this.projections != null ? this.projections[i] : null;
            if (i > 0) {
                writer.append(", ");
            }
            this.writeField(writer, fieldToFetch);
            if (this.customFunction || projection == null || projection.equals(fieldToFetch)) continue;
            writer.append(" as ");
            writer.append(projection);
        }
    }
}

