/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session.tokens;

import java.util.Arrays;
import java.util.List;
import net.ravendb.client.documents.session.tokens.QueryToken;

public class FromToken
extends QueryToken {
    private final String collectionName;
    private final String indexName;
    private final boolean dynamic;
    private final String alias;
    private static final List<Character> WHITE_SPACE_CHARS = Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n'));

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public String getAlias() {
        return this.alias;
    }

    private FromToken(String indexName, String collectionName) {
        this(indexName, collectionName, null);
    }

    private FromToken(String indexName, String collectionName, String alias) {
        this.collectionName = collectionName;
        this.indexName = indexName;
        this.dynamic = collectionName != null;
        this.alias = alias;
    }

    public static FromToken create(String indexName, String collectionName, String alias) {
        return new FromToken(indexName, collectionName, alias);
    }

    @Override
    public void writeTo(StringBuilder writer) {
        if (this.indexName == null && this.collectionName == null) {
            throw new IllegalStateException("Either indexName or collectionName must be specified");
        }
        if (this.dynamic) {
            writer.append("from ");
            if (this.collectionName.chars().anyMatch(x -> WHITE_SPACE_CHARS.contains(Character.valueOf((char)x)))) {
                if (this.collectionName.contains("\"")) {
                    this.throwInvalidCollectionName();
                }
                writer.append('\"').append(this.collectionName).append('\"');
            } else {
                this.writeField(writer, this.collectionName);
            }
        } else {
            writer.append("from index '").append(this.indexName).append("'");
        }
        if (this.alias != null) {
            writer.append(" as ").append(this.alias);
        }
    }

    private void throwInvalidCollectionName() {
        throw new IllegalArgumentException("Collection name cannot contain a quote, but was: " + this.collectionName);
    }
}

