/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.extensions;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import java.io.IOException;
import java.text.DateFormat;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.queries.IndexQuery;
import net.ravendb.client.documents.session.EntityToJson;
import net.ravendb.client.primitives.NetDateFormat;
import net.ravendb.client.primitives.SharpAwareJacksonAnnotationIntrospector;
import net.ravendb.client.util.TimeUtils;
import org.apache.commons.lang3.StringUtils;

public class JsonExtensions {
    private static ObjectMapper _defaultMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMapper getDefaultMapper() {
        if (_defaultMapper != null) return _defaultMapper;
        Class<JsonExtensions> clazz = JsonExtensions.class;
        synchronized (JsonExtensions.class) {
            if (_defaultMapper != null) return _defaultMapper;
            _defaultMapper = JsonExtensions.createDefaultJsonSerializer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _defaultMapper;
        }
    }

    public static ObjectMapper createDefaultJsonSerializer() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new DotNetNamingStrategy());
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.setConfig(objectMapper.getSerializationConfig().with((DateFormat)new NetDateFormat()));
        objectMapper.setConfig((DeserializationConfig)objectMapper.getDeserializationConfig().with((DateFormat)new NetDateFormat()));
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new SharpAwareJacksonAnnotationIntrospector());
        return objectMapper;
    }

    public static ObjectMapper getDefaultEntityMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.setConfig(objectMapper.getSerializationConfig().with((DateFormat)new NetDateFormat()));
        objectMapper.setConfig((DeserializationConfig)objectMapper.getDeserializationConfig().with((DateFormat)new NetDateFormat()));
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new SharpAwareJacksonAnnotationIntrospector());
        return objectMapper;
    }

    public static void writeIndexQuery(JsonGenerator generator, DocumentConventions conventions, IndexQuery query) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("Query", query.getQuery());
        if (query.isPageSizeSet() && query.getPageSize() >= 0) {
            generator.writeNumberField("PageSize", query.getPageSize());
        }
        if (query.isWaitForNonStaleResults()) {
            generator.writeBooleanField("WaitForNonStaleResults", query.isWaitForNonStaleResults());
        }
        if (query.getStart() > 0) {
            generator.writeNumberField("Start", query.getStart());
        }
        if (query.getWaitForNonStaleResultsTimeout() != null) {
            generator.writeStringField("WaitForNonStaleResultsTimeout", TimeUtils.durationToTimeSpan(query.getWaitForNonStaleResultsTimeout()));
        }
        if (query.isDisableCaching()) {
            generator.writeBooleanField("DisableCaching", query.isDisableCaching());
        }
        if (query.isSkipDuplicateChecking()) {
            generator.writeBooleanField("SkipDuplicateChecking", query.isSkipDuplicateChecking());
        }
        generator.writeFieldName("QueryParameters");
        if (query.getQueryParameters() != null) {
            generator.writeObject((Object)EntityToJson.convertEntityToJson(query.getQueryParameters(), conventions));
        } else {
            generator.writeNull();
        }
        generator.writeEndObject();
    }

    public static boolean tryGetConflict(JsonNode metadata) {
        if (metadata.has("@conflict")) {
            return metadata.get("@conflict").asBoolean();
        }
        return false;
    }

    public static class DotNetNamingStrategy
    extends PropertyNamingStrategy {
        public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
            return StringUtils.capitalize((String)defaultName);
        }

        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return StringUtils.capitalize((String)defaultName);
        }

        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return StringUtils.capitalize((String)defaultName);
        }

        public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
            return StringUtils.capitalize((String)defaultName);
        }
    }
}

