/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.http;

import java.util.HashMap;
import java.util.Map;

public class ClusterTopology {
    private String lastNodeId;
    private String topologyId;
    private Map<String, String> members;
    private Map<String, String> promotables;
    private Map<String, String> watchers;

    public boolean contains(String node) {
        if (this.members != null && this.members.containsKey(node)) {
            return true;
        }
        if (this.promotables != null && this.promotables.containsKey(node)) {
            return true;
        }
        return this.watchers != null && this.watchers.containsKey(node);
    }

    public String getUrlFromTag(String tag) {
        if (tag == null) {
            return null;
        }
        if (this.members != null && this.members.containsKey(tag)) {
            return this.members.get(tag);
        }
        if (this.promotables != null && this.promotables.containsKey(tag)) {
            return this.promotables.get(tag);
        }
        if (this.watchers != null && this.watchers.containsKey(tag)) {
            return this.watchers.get(tag);
        }
        return null;
    }

    public Map<String, String> getAllNodes() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.members != null) {
            for (Map.Entry<String, String> entry : this.members.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.promotables != null) {
            for (Map.Entry<String, String> entry : this.promotables.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.watchers != null) {
            for (Map.Entry<String, String> entry : this.watchers.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public String getLastNodeId() {
        return this.lastNodeId;
    }

    public void setLastNodeId(String lastNodeId) {
        this.lastNodeId = lastNodeId;
    }

    public String getTopologyId() {
        return this.topologyId;
    }

    public void setTopologyId(String topologyId) {
        this.topologyId = topologyId;
    }

    public Map<String, String> getMembers() {
        return this.members;
    }

    public void setMembers(Map<String, String> members) {
        this.members = members;
    }

    public Map<String, String> getPromotables() {
        return this.promotables;
    }

    public void setPromotables(Map<String, String> promotables) {
        this.promotables = promotables;
    }

    public Map<String, String> getWatchers() {
        return this.watchers;
    }

    public void setWatchers(Map<String, String> watchers) {
        this.watchers = watchers;
    }
}

