/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.http;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.ravendb.client.exceptions.AllTopologyNodesDownException;
import net.ravendb.client.http.CurrentIndexAndNode;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.http.Topology;
import net.ravendb.client.primitives.CleanCloseable;
import net.ravendb.client.primitives.Timer;

public class NodeSelector
implements CleanCloseable {
    private Timer _updateFastestNodeTimer;
    private NodeSelectorState _state;

    public Topology getTopology() {
        return this._state.topology;
    }

    public NodeSelector(Topology topology) {
        this._state = new NodeSelectorState(0, topology);
    }

    public void onFailedRequest(int nodeIndex) {
        NodeSelectorState state = this._state;
        if (nodeIndex < 0 || nodeIndex >= state.failures.length) {
            return;
        }
        state.failures[nodeIndex].incrementAndGet();
    }

    public boolean onUpdateTopology(Topology topology) {
        return this.onUpdateTopology(topology, false);
    }

    public boolean onUpdateTopology(Topology topology, boolean forceUpdate) {
        NodeSelectorState state;
        if (topology == null) {
            return false;
        }
        if (this._state.topology.getEtag() >= topology.getEtag() && !forceUpdate) {
            return false;
        }
        this._state = state = new NodeSelectorState(0, topology);
        return true;
    }

    public CurrentIndexAndNode getPreferredNode() {
        NodeSelectorState state = this._state;
        AtomicInteger[] stateFailures = state.failures;
        List<ServerNode> serverNodes = state.nodes;
        int len = Math.min(serverNodes.size(), stateFailures.length);
        for (int i = 0; i < len; ++i) {
            if (stateFailures[i].get() != 0) continue;
            return new CurrentIndexAndNode(i, serverNodes.get(i));
        }
        return NodeSelector.unlikelyEveryoneFaultedChoice(state);
    }

    private static CurrentIndexAndNode unlikelyEveryoneFaultedChoice(NodeSelectorState state) {
        if (state.nodes.size() == 0) {
            throw new AllTopologyNodesDownException("There are no nodes in the topology at all");
        }
        return new CurrentIndexAndNode(0, state.nodes.get(0));
    }

    public CurrentIndexAndNode getNodeBySessionId(int sessionId) {
        int index;
        int i;
        NodeSelectorState state = this._state;
        for (i = index = sessionId % state.topology.getNodes().size(); i < state.failures.length; ++i) {
            if (state.failures[i].get() != 0 || state.nodes.get(i).getServerRole() != ServerNode.Role.MEMBER) continue;
            return new CurrentIndexAndNode(i, state.nodes.get(i));
        }
        for (i = 0; i < index; ++i) {
            if (state.failures[i].get() != 0 || state.nodes.get(i).getServerRole() != ServerNode.Role.MEMBER) continue;
            return new CurrentIndexAndNode(i, state.nodes.get(i));
        }
        return this.getPreferredNode();
    }

    public CurrentIndexAndNode getFastestNode() {
        NodeSelectorState state = this._state;
        if (state.failures[state.fastest].get() == 0 && state.nodes.get(state.fastest).getServerRole() == ServerNode.Role.MEMBER) {
            return new CurrentIndexAndNode(state.fastest, state.nodes.get(state.fastest));
        }
        this.switchToSpeedTestPhase();
        return this.getPreferredNode();
    }

    public void restoreNodeIndex(int nodeIndex) {
        NodeSelectorState state = this._state;
        if (state.currentNodeIndex < nodeIndex) {
            return;
        }
        state.failures[nodeIndex].set(0);
    }

    protected static void throwEmptyTopology() {
        throw new IllegalStateException("Empty database topology, this shouldn't happen.");
    }

    private void switchToSpeedTestPhase() {
        NodeSelectorState state = this._state;
        if (!state.speedTestMode.compareAndSet(0, 1)) {
            return;
        }
        Arrays.fill(state.fastestRecords, 0);
        state.speedTestMode.incrementAndGet();
    }

    public boolean inSpeedTestPhase() {
        return this._state.speedTestMode.get() > 1;
    }

    public void recordFastest(int index, ServerNode node) {
        NodeSelectorState state = this._state;
        int[] stateFastest = state.fastestRecords;
        if (index < 0 || index >= stateFastest.length) {
            return;
        }
        if (node != state.nodes.get(index)) {
            return;
        }
        int n = index;
        stateFastest[n] = stateFastest[n] + 1;
        if (stateFastest[n] >= 10) {
            this.selectFastest(state, index);
        }
        if (state.speedTestMode.incrementAndGet() <= state.nodes.size() * 10) {
            return;
        }
        int maxIndex = NodeSelector.findMaxIndex(state);
        this.selectFastest(state, maxIndex);
    }

    private static int findMaxIndex(NodeSelectorState state) {
        int[] stateFastest = state.fastestRecords;
        int maxIndex = 0;
        int maxValue = 0;
        for (int i = 0; i < stateFastest.length; ++i) {
            if (maxValue >= stateFastest[i]) continue;
            maxIndex = i;
            maxValue = stateFastest[i];
        }
        return maxIndex;
    }

    private void selectFastest(NodeSelectorState state, int index) {
        state.fastest = index;
        state.speedTestMode.set(0);
        if (this._updateFastestNodeTimer != null) {
            this._updateFastestNodeTimer.change(Duration.ofMinutes(1L));
        } else {
            this._updateFastestNodeTimer = new Timer(this::switchToSpeedTestPhase, Duration.ofMinutes(1L));
        }
    }

    public void scheduleSpeedTest() {
        this.switchToSpeedTestPhase();
    }

    @Override
    public void close() {
        if (this._updateFastestNodeTimer != null) {
            this._updateFastestNodeTimer.close();
        }
    }

    private static class NodeSelectorState {
        public final Topology topology;
        public final int currentNodeIndex;
        public final List<ServerNode> nodes;
        public final AtomicInteger[] failures;
        public final int[] fastestRecords;
        public int fastest;
        public final AtomicInteger speedTestMode = new AtomicInteger(0);

        public NodeSelectorState(int currentNodeIndex, Topology topology) {
            this.topology = topology;
            this.currentNodeIndex = currentNodeIndex;
            this.nodes = topology.getNodes();
            this.failures = new AtomicInteger[topology.getNodes().size()];
            for (int i = 0; i < this.failures.length; ++i) {
                this.failures[i] = new AtomicInteger(0);
            }
            this.fastestRecords = new int[topology.getNodes().size()];
        }
    }
}

