/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ravendb.client.documents.session.DocumentInfo;
import net.ravendb.client.documents.session.DocumentsChanges;
import org.apache.commons.collections4.CollectionUtils;

public class JsonOperation {
    public static boolean entityChanged(ObjectNode newObj, DocumentInfo documentInfo, Map<String, List<DocumentsChanges>> changes) {
        ArrayList<DocumentsChanges> docChanges;
        ArrayList<DocumentsChanges> arrayList = docChanges = changes != null ? new ArrayList<DocumentsChanges>() : null;
        if (!documentInfo.isNewDocument() && documentInfo.getDocument() != null) {
            return JsonOperation.compareJson(documentInfo.getId(), documentInfo.getDocument(), newObj, changes, docChanges);
        }
        if (changes == null) {
            return true;
        }
        JsonOperation.newChange(null, null, null, docChanges, DocumentsChanges.ChangeType.DOCUMENT_ADDED);
        changes.put(documentInfo.getId(), docChanges);
        return true;
    }

    private static boolean compareJson(String id, ObjectNode originalJson, ObjectNode newJson, Map<String, List<DocumentsChanges>> changes, List<DocumentsChanges> docChanges) {
        ArrayList newJsonProps = Lists.newArrayList((Iterator)newJson.fieldNames());
        ArrayList oldJsonProps = Lists.newArrayList((Iterator)originalJson.fieldNames());
        Collection newFields = CollectionUtils.subtract((Iterable)newJsonProps, (Iterable)oldJsonProps);
        Collection removedFields = CollectionUtils.subtract((Iterable)oldJsonProps, (Iterable)newJsonProps);
        for (String field : removedFields) {
            if (changes == null) {
                return true;
            }
            JsonOperation.newChange(field, null, null, docChanges, DocumentsChanges.ChangeType.REMOVED_FIELD);
        }
        block7: for (String prop : newJsonProps) {
            if ("@last-modified".equals(prop) || "@collection".equals(prop) || "@change-vector".equals(prop) || "@id".equals(prop)) continue;
            if (newFields.contains(prop)) {
                if (changes == null) {
                    return true;
                }
                JsonOperation.newChange(prop, newJson.get(prop), null, docChanges, DocumentsChanges.ChangeType.NEW_FIELD);
                continue;
            }
            JsonNode newProp = newJson.get(prop);
            JsonNode oldProp = originalJson.get(prop);
            switch (newProp.getNodeType()) {
                case NUMBER: 
                case BOOLEAN: 
                case STRING: {
                    if (newProp.equals((Object)oldProp)) continue block7;
                    if (JsonOperation.compareValues((ValueNode)oldProp, (ValueNode)newProp)) break;
                    if (changes == null) {
                        return true;
                    }
                    JsonOperation.newChange(prop, newProp, oldProp, docChanges, DocumentsChanges.ChangeType.FIELD_CHANGED);
                    break;
                }
                case NULL: {
                    if (oldProp.isNull()) break;
                    if (changes == null) {
                        return true;
                    }
                    JsonOperation.newChange(prop, null, oldProp, docChanges, DocumentsChanges.ChangeType.FIELD_CHANGED);
                    break;
                }
                case ARRAY: {
                    if (oldProp == null || !(oldProp instanceof ArrayNode)) {
                        if (changes == null) {
                            return true;
                        }
                        JsonOperation.newChange(prop, newProp, oldProp, docChanges, DocumentsChanges.ChangeType.FIELD_CHANGED);
                        break;
                    }
                    boolean changed = JsonOperation.compareJsonArray(id, (ArrayNode)oldProp, (ArrayNode)newProp, changes, docChanges, prop);
                    if (changes != null || !changed) continue block7;
                    return true;
                }
                case OBJECT: {
                    if (oldProp == null || oldProp.isNull()) {
                        if (changes == null) {
                            return true;
                        }
                        JsonOperation.newChange(prop, newProp, null, docChanges, DocumentsChanges.ChangeType.FIELD_CHANGED);
                        break;
                    }
                    boolean changed = JsonOperation.compareJson(id, (ObjectNode)oldProp, (ObjectNode)newProp, changes, docChanges);
                    if (changes != null || !changed) continue block7;
                    return true;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (changes == null || docChanges.size() <= 0) {
            return false;
        }
        changes.put(id, docChanges);
        return true;
    }

    private static boolean compareValues(ValueNode oldProp, ValueNode newProp) {
        if (!oldProp.getNodeType().equals((Object)newProp.getNodeType())) {
            return true;
        }
        return oldProp.asText().equals(newProp.asText());
    }

    private static boolean compareJsonArray(String id, ArrayNode oldArray, ArrayNode newArray, Map<String, List<DocumentsChanges>> changes, List<DocumentsChanges> docChanges, String propName) {
        int position;
        if (oldArray.size() != newArray.size() && changes == null) {
            return true;
        }
        boolean changed = false;
        block5: for (position = 0; position < oldArray.size() && position < newArray.size(); ++position) {
            switch (oldArray.get(position).getNodeType()) {
                case OBJECT: {
                    if (JsonNodeType.OBJECT.equals((Object)newArray.get(position).getNodeType())) {
                        changed |= JsonOperation.compareJson(id, (ObjectNode)oldArray.get(position), (ObjectNode)newArray.get(position), changes, docChanges);
                        continue block5;
                    }
                    changed = true;
                    if (changes == null) continue block5;
                    JsonOperation.newChange(propName, newArray.get(position), oldArray.get(position), docChanges, DocumentsChanges.ChangeType.ARRAY_VALUE_ADDED);
                    continue block5;
                }
                case ARRAY: {
                    if (JsonNodeType.ARRAY.equals((Object)newArray.get(position).getNodeType())) {
                        changed |= JsonOperation.compareJsonArray(id, (ArrayNode)oldArray.get(position), (ArrayNode)newArray.get(position), changes, docChanges, propName);
                        continue block5;
                    }
                    changed = true;
                    if (changes == null) continue block5;
                    JsonOperation.newChange(propName, newArray.get(position), oldArray.get(position), docChanges, DocumentsChanges.ChangeType.ARRAY_VALUE_CHANGED);
                    continue block5;
                }
                case NULL: {
                    if (newArray.get(position) == null || newArray.get(position).isNull()) continue block5;
                    changed = true;
                    if (changes == null) continue block5;
                    JsonOperation.newChange(propName, newArray.get(position), oldArray.get(position), docChanges, DocumentsChanges.ChangeType.ARRAY_VALUE_ADDED);
                    continue block5;
                }
                default: {
                    if (oldArray.get(position).asText().equals(newArray.get(position).asText())) continue block5;
                    if (changes != null) {
                        JsonOperation.newChange(propName, newArray.get(position), oldArray.get(position), docChanges, DocumentsChanges.ChangeType.ARRAY_VALUE_CHANGED);
                    }
                    changed = true;
                }
            }
        }
        if (changes == null) {
            return changed;
        }
        while (position < oldArray.size()) {
            JsonOperation.newChange(propName, null, oldArray.get(position), docChanges, DocumentsChanges.ChangeType.ARRAY_VALUE_REMOVED);
            ++position;
        }
        while (position < newArray.size()) {
            JsonOperation.newChange(propName, newArray.get(position), null, docChanges, DocumentsChanges.ChangeType.ARRAY_VALUE_ADDED);
            ++position;
        }
        return changed;
    }

    private static void newChange(String name, Object newValue, Object oldValue, List<DocumentsChanges> docChanges, DocumentsChanges.ChangeType change) {
        NumericNode node;
        if (newValue instanceof NumericNode) {
            node = (NumericNode)newValue;
            newValue = node.numberValue();
        }
        if (oldValue instanceof NumericNode) {
            node = (NumericNode)oldValue;
            oldValue = node.numberValue();
        }
        DocumentsChanges documentsChanges = new DocumentsChanges();
        documentsChanges.setFieldName(name);
        documentsChanges.setFieldNewValue(newValue);
        documentsChanges.setFieldOldValue(oldValue);
        documentsChanges.setChange(change);
        docChanges.add(documentsChanges);
    }
}

