/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.json;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.ravendb.client.documents.session.IMetadataDictionary;
import org.apache.commons.lang3.NotImplementedException;

public class MetadataAsDictionary
implements IMetadataDictionary {
    private Map<String, Object> _metadata;
    private final ObjectNode _source;

    public MetadataAsDictionary(ObjectNode metadata) {
        this._source = metadata;
    }

    public MetadataAsDictionary() {
        this(new HashMap<String, Object>());
    }

    public MetadataAsDictionary(Map<String, Object> metadata) {
        this._metadata = metadata;
        this._source = null;
    }

    private void init() {
        this._metadata = new HashMap<String, Object>();
        Iterator fields = this._source.fieldNames();
        while (fields.hasNext()) {
            String fieldName = (String)fields.next();
            this._metadata.put(fieldName, MetadataAsDictionary.convertValue(this._source.get(fieldName)));
        }
    }

    private static Object convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof TextNode) {
            return ((TextNode)value).asText();
        }
        if (value instanceof NumericNode) {
            return ((NumericNode)value).numberValue();
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Float) {
            return value;
        }
        if (value instanceof ObjectNode) {
            return new MetadataAsDictionary((ObjectNode)value);
        }
        if (value instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)value;
            Object[] result = new Object[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                result[i] = MetadataAsDictionary.convertValue(array.get(i));
            }
            return result;
        }
        throw new NotImplementedException("Implement support for numbers and more");
    }

    @Override
    public int size() {
        if (this._metadata != null) {
            return this._metadata.size();
        }
        return this._source.size();
    }

    @Override
    public Object put(String key, Object value) {
        if (this._metadata == null) {
            this.init();
        }
        return this._metadata.put(key, value);
    }

    @Override
    public Object get(Object key) {
        if (this._metadata != null) {
            return this._metadata.get(key);
        }
        return MetadataAsDictionary.convertValue(this._source.get((String)key));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (this._metadata == null) {
            this.init();
        }
        this._metadata.putAll(m);
    }

    @Override
    public void clear() {
        if (this._metadata == null) {
            this.init();
        }
        this._metadata.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this._metadata != null) {
            return this._metadata.containsKey(key);
        }
        return this._source.has((String)key);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this._metadata == null) {
            this.init();
        }
        return this._metadata.entrySet();
    }

    @Override
    public Object remove(Object key) {
        if (this._metadata == null) {
            this.init();
        }
        return this._metadata.remove(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this._metadata == null) {
            this.init();
        }
        return this._metadata.containsValue(value);
    }

    @Override
    public Collection<Object> values() {
        if (this._metadata == null) {
            this.init();
        }
        return this._metadata.values();
    }

    @Override
    public Set<String> keySet() {
        if (this._metadata == null) {
            this.init();
        }
        return this._metadata.keySet();
    }
}

