/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.serverwide.commands;

import java.io.IOException;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.serverwide.commands.TcpConnectionInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class GetTcpInfoCommand
extends RavenCommand<TcpConnectionInfo> {
    private final String tag;
    private final String dbName;
    private ServerNode requestedNode;

    public GetTcpInfoCommand(String tag) {
        this(tag, null);
    }

    public GetTcpInfoCommand(String tag, String dbName) {
        super(TcpConnectionInfo.class);
        this.tag = tag;
        this.dbName = dbName;
    }

    @Override
    public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
        url.value = StringUtils.isEmpty((CharSequence)this.dbName) ? node.getUrl() + "/info/tcp?tcp=" + this.tag : node.getUrl() + "/databases/" + this.dbName + "/info/tcp?tag=" + this.tag;
        this.requestedNode = node;
        return new HttpGet();
    }

    public ServerNode getRequestedNode() {
        return this.requestedNode;
    }

    public void setRequestedNode(ServerNode requestedNode) {
        this.requestedNode = requestedNode;
    }

    @Override
    public void setResponse(String response, boolean fromCache) throws IOException {
        if (response == null) {
            GetTcpInfoCommand.throwInvalidResponse();
        }
        this.result = this.mapper.readValue(response, TcpConnectionInfo.class);
    }

    @Override
    public boolean isReadRequest() {
        return true;
    }
}

