/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.serverwide.operations;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Optional;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.ExceptionsUtils;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.serverwide.DatabaseRecord;
import net.ravendb.client.serverwide.operations.DatabasePutResult;
import net.ravendb.client.serverwide.operations.IServerOperation;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class CreateDatabaseOperation
implements IServerOperation<DatabasePutResult> {
    private final DatabaseRecord databaseRecord;
    private final int replicationFactor;

    public CreateDatabaseOperation(DatabaseRecord databaseRecord) {
        this(databaseRecord, 1);
    }

    public CreateDatabaseOperation(DatabaseRecord databaseRecord, int replicationFactor) {
        this.databaseRecord = databaseRecord;
        this.replicationFactor = replicationFactor;
    }

    @Override
    public RavenCommand<DatabasePutResult> getCommand(DocumentConventions conventions) {
        return new CreateDatabaseCommand(conventions, this.databaseRecord, this.replicationFactor);
    }

    private static class CreateDatabaseCommand
    extends RavenCommand<DatabasePutResult> {
        private final DocumentConventions conventions;
        private final DatabaseRecord databaseRecord;
        private final int replicationFactor;
        private final String databaseName;

        public CreateDatabaseCommand(DocumentConventions conventions, DatabaseRecord databaseRecord, int replicationFactor) {
            super(DatabasePutResult.class);
            this.conventions = conventions;
            this.databaseRecord = databaseRecord;
            this.replicationFactor = replicationFactor;
            this.databaseName = Optional.ofNullable(databaseRecord).map(x -> x.getDatabaseName()).orElseThrow(() -> new IllegalArgumentException("Database name is required"));
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/admin/databases?name=" + this.databaseName;
            url.value = url.value + "&replicationFactor=" + this.replicationFactor;
            try {
                String databaseDocument = this.mapper.writeValueAsString((Object)this.databaseRecord);
                HttpPut request = new HttpPut();
                request.setEntity((HttpEntity)new StringEntity(databaseDocument, ContentType.APPLICATION_JSON));
                return request;
            }
            catch (JsonProcessingException e) {
                throw ExceptionsUtils.unwrapException(e);
            }
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                CreateDatabaseCommand.throwInvalidResponse();
            }
            this.result = this.mapper.readValue(response, DatabasePutResult.class);
        }

        @Override
        public boolean isReadRequest() {
            return false;
        }
    }
}

