/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.test.driver;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.ravendb.client.documents.DocumentStore;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.indexes.IndexState;
import net.ravendb.client.documents.operations.DatabaseStatistics;
import net.ravendb.client.documents.operations.GetStatisticsOperation;
import net.ravendb.client.documents.operations.MaintenanceOperationExecutor;
import net.ravendb.client.documents.session.IDocumentSession;
import net.ravendb.client.exceptions.TimeoutException;
import net.ravendb.client.exceptions.cluster.NoLeaderException;
import net.ravendb.client.exceptions.database.DatabaseDoesNotExistException;
import net.ravendb.client.primitives.CleanCloseable;
import net.ravendb.client.serverwide.DatabaseRecord;
import net.ravendb.client.serverwide.operations.CreateDatabaseOperation;
import net.ravendb.client.serverwide.operations.DeleteDatabasesOperation;
import net.ravendb.client.test.driver.RavenServerLocator;
import net.ravendb.client.test.driver.RavenServerRunner;
import net.ravendb.client.util.UrlUtils;
import org.apache.commons.io.IOUtils;

public abstract class RavenTestDriver
implements CleanCloseable {
    private final RavenServerLocator locator;
    private final RavenServerLocator securedLocator;
    private static IDocumentStore globalServer;
    private static Process globalServerProcess;
    private static IDocumentStore globalSecuredServer;
    private static Process globalSecuredServerProcess;
    private final Set<DocumentStore> documentStores = Sets.newConcurrentHashSet();
    private static final AtomicInteger index;
    protected boolean disposed;
    public static boolean debug;

    public RavenTestDriver(RavenServerLocator locator, RavenServerLocator securedLocator) {
        this.locator = locator;
        this.securedLocator = securedLocator;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public DocumentStore getSecuredDocumentStore() throws Exception {
        return this.getDocumentStore("test_db", true, null);
    }

    public KeyStore getTestClientCertificate() throws IOException, GeneralSecurityException {
        KeyStore clientStore = KeyStore.getInstance("PKCS12");
        clientStore.load(new FileInputStream(this.securedLocator.getServerCertificatePath()), "".toCharArray());
        return clientStore;
    }

    public DocumentStore getDocumentStore() throws Exception {
        return this.getDocumentStore("test_db");
    }

    public DocumentStore getSecuredDocumentStore(String database) throws Exception {
        return this.getDocumentStore(database, true, null);
    }

    public DocumentStore getDocumentStore(String database) throws Exception {
        return this.getDocumentStore(database, false, null);
    }

    protected void customizeDbRecord(DatabaseRecord dbRecord) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DocumentStore getDocumentStore(String database, boolean secured, Duration waitForIndexingTimeout) throws Exception {
        String name = database + "_" + index.incrementAndGet();
        RavenTestDriver.reportInfo("getDocumentStore for db " + database + ".");
        if (this.getGlobalServer(secured) == null) {
            Class<RavenTestDriver> clazz = RavenTestDriver.class;
            // MONITORENTER : net.ravendb.client.test.driver.RavenTestDriver.class
            if (this.getGlobalServer(secured) == null) {
                this.runServer(secured);
            }
            // MONITOREXIT : clazz
        }
        IDocumentStore documentStore = this.getGlobalServer(secured);
        DatabaseRecord databaseRecord = new DatabaseRecord();
        databaseRecord.setDatabaseName(name);
        this.customizeDbRecord(databaseRecord);
        CreateDatabaseOperation createDatabaseOperation = new CreateDatabaseOperation(databaseRecord);
        documentStore.maintenance().server().send(createDatabaseOperation);
        DocumentStore store = new DocumentStore();
        store.setUrls(documentStore.getUrls());
        store.setDatabase(name);
        if (secured) {
            store.setCertificate(this.getTestClientCertificate());
        }
        store.initialize();
        store.addAfterCloseListener((sender, event) -> {
            if (!this.documentStores.contains(store)) {
                return;
            }
            try {
                store.maintenance().server().send(new DeleteDatabasesOperation(store.getDatabase(), true));
            }
            catch (DatabaseDoesNotExistException databaseDoesNotExistException) {
            }
            catch (NoLeaderException noLeaderException) {
                // empty catch block
            }
        });
        this.setupDatabase(store);
        this.documentStores.add(store);
        return store;
    }

    protected void setupDatabase(IDocumentStore documentStore) {
    }

    private IDocumentStore runServer(boolean secured) throws Exception {
        StringBuilder sb;
        String url;
        Process process;
        block7: {
            String prefix;
            String line;
            process = RavenServerRunner.run(secured ? this.securedLocator : this.locator);
            this.setGlobalServerProcess(secured, process);
            RavenTestDriver.reportInfo("Starting global server");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> RavenTestDriver.killGlobalServerProcess(secured)));
            url = null;
            InputStream stdout = this.getGlobalProcess(secured).getInputStream();
            sb = new StringBuilder();
            Stopwatch startupDuration = Stopwatch.createStarted();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
            ArrayList<String> readLines = new ArrayList<String>();
            do {
                line = reader.readLine();
                readLines.add(line);
                if (line == null) {
                    throw new RuntimeException(readLines.stream().collect(Collectors.joining(System.lineSeparator())) + IOUtils.toString((InputStream)this.getGlobalProcess(secured).getInputStream(), (String)"UTF-8"));
                }
                if (startupDuration.elapsed(TimeUnit.MINUTES) >= 1L) break block7;
            } while (!line.startsWith(prefix = "Server available on: "));
            url = line.substring(prefix.length());
        }
        if (url == null) {
            String log = sb.toString();
            RavenTestDriver.reportInfo(log);
            try {
                process.destroyForcibly();
            }
            catch (Exception e) {
                RavenTestDriver.reportError(e);
            }
            throw new IllegalStateException("Unable to start server, log is: " + log);
        }
        DocumentStore store = new DocumentStore();
        store.setUrls(new String[]{url});
        store.setDatabase("test.manager");
        if (secured) {
            globalSecuredServer = store;
            KeyStore clientCert = this.getTestClientCertificate();
            store.setCertificate(clientCert);
        } else {
            globalServer = store;
        }
        return store.initialize();
    }

    private static void killGlobalServerProcess(boolean secured) {
        Process p;
        if (secured) {
            p = globalSecuredServerProcess;
            globalSecuredServerProcess = null;
        } else {
            p = globalServerProcess;
            globalServerProcess = null;
        }
        if (p != null && p.isAlive()) {
            RavenTestDriver.reportInfo("Kill global server");
            try {
                p.destroyForcibly();
            }
            catch (Exception e) {
                RavenTestDriver.reportError(e);
            }
        }
    }

    private IDocumentStore getGlobalServer(boolean secured) {
        return secured ? globalSecuredServer : globalServer;
    }

    private Process getGlobalProcess(boolean secured) {
        return secured ? globalSecuredServerProcess : globalServerProcess;
    }

    private void setGlobalServerProcess(boolean secured, Process p) {
        if (secured) {
            globalSecuredServerProcess = p;
        } else {
            globalServerProcess = p;
        }
    }

    public void waitForIndexing(IDocumentStore store) {
        this.waitForIndexing(store, null, null);
    }

    public void waitForIndexing(IDocumentStore store, String database) {
        this.waitForIndexing(store, database, null);
    }

    public void waitForIndexing(IDocumentStore store, String database, Duration timeout) {
        MaintenanceOperationExecutor admin = store.maintenance().forDatabase(database);
        if (timeout == null) {
            timeout = Duration.ofMinutes(1L);
        }
        Stopwatch sp = Stopwatch.createStarted();
        while (sp.elapsed(TimeUnit.MILLISECONDS) < timeout.toMillis()) {
            DatabaseStatistics databaseStatistics = admin.send(new GetStatisticsOperation());
            List indexes = Arrays.stream(databaseStatistics.getIndexes()).filter(x -> !IndexState.DISABLED.equals((Object)x.getState())).collect(Collectors.toList());
            if (indexes.stream().allMatch(x -> !x.isStale() && !x.getName().startsWith("ReplacementOf/"))) {
                return;
            }
            if (Arrays.stream(databaseStatistics.getIndexes()).anyMatch(x -> IndexState.ERROR.equals((Object)x.getState()))) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new TimeoutException();
    }

    public void waitForUserToContinueTheTest(IDocumentStore store) {
        String databaseNameEncoded = UrlUtils.escapeDataString(store.getDatabase());
        String documentsPage = store.getUrls()[0] + "/studio/index.html#databases/documents?&database=" + databaseNameEncoded + "&withStop=true";
        this.openBrowser(documentsPage);
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IDocumentSession session = store.openSession();
            Throwable throwable = null;
            try {
                if (session.load(ObjectNode.class, "Debug/Done") == null) continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session == null) continue;
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                session.close();
                continue;
            }
            break;
        }
    }

    protected void openBrowser(String url) {
        System.out.println(url);
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec("xdg-open " + url);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void reportError(Exception e) {
        if (!debug) {
            return;
        }
        if (e == null) {
            throw new IllegalArgumentException("Exception can not be null");
        }
    }

    private static void reportInfo(String message) {
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (DocumentStore documentStore : this.documentStores) {
            try {
                documentStore.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        this.disposed = true;
        if (exceptions.size() > 0) {
            throw new RuntimeException(exceptions.stream().map(x -> x.toString()).collect(Collectors.joining(", ")));
        }
    }

    static {
        index = new AtomicInteger();
    }
}

