/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestIdentifier;

public class JunitTestHierarchy {
    private static final JunitTestHierarchy INSTANCE = new JunitTestHierarchy();
    private final Map<String, String> classPathToDisplayName = new ConcurrentHashMap<String, String>();
    private final Map<String, String> idToDisplayName = new ConcurrentHashMap<String, String>();
    private final Map<String, String> idToParent = new ConcurrentHashMap<String, String>();

    public static JunitTestHierarchy getInstance() {
        return INSTANCE;
    }

    public void testSuiteStarted(TestIdentifier testIdentifier) {
        this.idToDisplayName.put(testIdentifier.getUniqueId(), testIdentifier.getDisplayName());
        if (testIdentifier.getSource().isPresent() && testIdentifier.getSource().get() instanceof ClassSource) {
            String className = ((ClassSource)testIdentifier.getSource().get()).getClassName();
            this.classPathToDisplayName.put(className, testIdentifier.getDisplayName());
        }
        testIdentifier.getParentId().ifPresent(parentId -> this.idToParent.put(testIdentifier.getUniqueId(), (String)parentId));
    }
}

