/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.utils;

import io.restassured.filter.Filter;
import io.restassured.filter.log.LogDetail;
import io.restassured.http.ContentType;
import io.restassured.internal.support.Prettifier;
import io.restassured.response.Response;
import io.restassured.response.ResponseOptions;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.rest.RestMethod;
import net.serenitybdd.core.rest.RestQuery;
import net.serenitybdd.rest.RestStepListener;
import net.serenitybdd.rest.decorators.request.RequestSpecificationDecorated;
import net.serenitybdd.rest.filters.FieldsRecordingFilter;
import net.serenitybdd.rest.utils.RestResponseRecordingHelper;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import org.apache.commons.lang3.ObjectUtils;

public class RestReportingHelper {
    public RestReportingHelper() {
        StepEventBus.getEventBus().registerListener((StepListener)new RestStepListener());
    }

    private static boolean shouldRecordResponseBodyFor(Response result) {
        ContentType type = ContentType.fromContentType((String)result.contentType());
        return type != null && (ContentType.JSON == type || ContentType.XML == type || ContentType.TEXT == type || ContentType.HTML == type);
    }

    public RestQuery recordRestSpecificationData(RestMethod method, RequestSpecificationDecorated spec, String path, Object ... params) {
        HashMap<LogDetail, String> values = new HashMap<LogDetail, String>();
        for (Filter filter : spec.getDefinedFilters()) {
            if (!(filter instanceof FieldsRecordingFilter)) continue;
            FieldsRecordingFilter internal = (FieldsRecordingFilter)filter;
            values.put(internal.logDetail(), internal.recorded());
        }
        RestQuery query = RestQuery.withMethod((RestMethod)method).andPath((String)ObjectUtils.firstNonNull((Object[])new String[]{((String)values.get(LogDetail.URI)).replaceFirst("^Request URI:\t", ""), ""})).withContentType(String.valueOf(ContentType.fromContentType((String)spec.getContentType()))).withContent((String)ObjectUtils.firstNonNull((Object[])new String[]{(String)values.get(LogDetail.BODY), ""})).withRequestCookies((String)ObjectUtils.firstNonNull((Object[])new String[]{(String)values.get(LogDetail.COOKIES), ""})).withRequestHeaders((String)ObjectUtils.firstNonNull((Object[])new String[]{(String)values.get(LogDetail.HEADERS), ""}));
        return query;
    }

    public void registerCall(RestMethod method, Response response, RequestSpecificationDecorated spec, String path, Object ... params) {
        RestQuery restQuery = this.recordRestSpecificationData(method, spec, path, params);
        RestResponseRecordingHelper helper = new RestResponseRecordingHelper(true, LogDetail.HEADERS, LogDetail.COOKIES);
        Map<LogDetail, String> values = helper.print(response);
        if (RestReportingHelper.shouldRecordResponseBodyFor(response)) {
            String renderedBody = new Prettifier().getPrettifiedBodyIfPossible((ResponseOptions)response.getBody(), response.getBody());
            restQuery = restQuery.withResponse(renderedBody.isEmpty() ? response.asString() : renderedBody);
        }
        restQuery = restQuery.withStatusCode(Integer.valueOf(response.getStatusCode())).withResponseHeaders((String)ObjectUtils.firstNonNull((Object[])new String[]{values.get(LogDetail.HEADERS), ""})).withResponseCookies((String)ObjectUtils.firstNonNull((Object[])new String[]{values.get(LogDetail.COOKIES), ""}));
        StepEventBus.getEventBus().getBaseStepListener().recordRestQuery(restQuery);
    }

    public void registerCall(RestMethod method, RequestSpecificationDecorated spec, String path, RuntimeException throwable, Object ... params) {
        RestQuery restQuery = this.recordRestSpecificationData(method, spec, path, params);
        ExecutedStepDescription description = ExecutedStepDescription.withTitle((String)restQuery.toString());
        StepFailure failure = new StepFailure(description, (Throwable)throwable);
        StepEventBus.getEventBus().stepStarted(description);
        StepEventBus.getEventBus().getBaseStepListener().recordRestQuery(restQuery);
        StepEventBus.getEventBus().stepFailed(failure);
        if (Serenity.shouldThrowErrorsImmediately()) {
            throw throwable;
        }
    }
}

